"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def get_all(
    hub,
    ctx,
    association_type: str,
    resource_share_arns: List = None,
    resource_arn: str = None,
    principal: str = None,
    association_status: str = None,
    next_token: str = None,
    max_results: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Gets the resources or principals for the resource shares that you own.

    Args:
        association_type(str): The association type. Specify PRINCIPAL to list the principals that are associated with the specified resource share. Specify RESOURCE to list the resources that are associated with the specified resource share.
        resource_share_arns(List, optional): The Amazon Resource Names (ARN) of the resource shares. Defaults to None.
        resource_arn(str, optional): The Amazon Resource Name (ARN) of the resource. You cannot specify this parameter if the association type is PRINCIPAL. Defaults to None.
        principal(str, optional): The principal. You cannot specify this parameter if the association type is RESOURCE. Defaults to None.
        association_status(str, optional): The association status. Defaults to None.
        next_token(str, optional): The token for the next page of results. Defaults to None.
        max_results(int, optional): The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned nextToken value. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ram.resource.share.association.get_all(
                ctx, association_type=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ram.resource.share.association.get_all association_type=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ram",
        operation="get_resource_share_associations",
        op_kwargs={
            "associationType": association_type,
            "resourceShareArns": resource_share_arns,
            "resourceArn": resource_arn,
            "principal": principal,
            "associationStatus": association_status,
            "nextToken": next_token,
            "maxResults": max_results,
        },
    )
