"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def get_all(
    hub,
    ctx,
    resource_arns: List,
    principal: str = None,
    next_token: str = None,
    max_results: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Gets the policies for the specified resources that you own and have shared.

    Args:
        resource_arns(List): The Amazon Resource Names (ARN) of the resources.
        principal(str, optional): The principal. Defaults to None.
        next_token(str, optional): The token for the next page of results. Defaults to None.
        max_results(int, optional): The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned nextToken value. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ram.resource.policy.get_all(ctx, resource_arns=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ram.resource.policy.get_all resource_arns=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ram",
        operation="get_resource_policies",
        op_kwargs={
            "resourceArns": resource_arns,
            "principal": principal,
            "nextToken": next_token,
            "maxResults": max_results,
        },
    )
