"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def list_all(
    hub,
    ctx,
    resource_owner: str,
    principal: str = None,
    resource_type: str = None,
    resource_arns: List = None,
    resource_share_arns: List = None,
    next_token: str = None,
    max_results: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Lists the resources that you added to a resource shares or the resources that are shared with you.

    Args:
        resource_owner(str): The type of owner.
        principal(str, optional): The principal. Defaults to None.
        resource_type(str, optional): The resource type. Valid values: acm-pca:CertificateAuthority | appmesh:Mesh | codebuild:Project | codebuild:ReportGroup | ec2:CapacityReservation | ec2:DedicatedHost | ec2:LocalGatewayRouteTable | ec2:PrefixList | ec2:Subnet | ec2:TrafficMirrorTarget | ec2:TransitGateway | imagebuilder:Component | imagebuilder:Image | imagebuilder:ImageRecipe | imagebuilder:ContainerRecipe | glue:Catalog | glue:Database | glue:Table | license-manager:LicenseConfiguration I network-firewall:FirewallPolicy | network-firewall:StatefulRuleGroup | network-firewall:StatelessRuleGroup | outposts:Outpost | resource-groups:Group | rds:Cluster | route53resolver:ResolverQueryLogConfig | route53resolver:ResolverRule . Defaults to None.
        resource_arns(List, optional): The Amazon Resource Names (ARN) of the resources. Defaults to None.
        resource_share_arns(List, optional): The Amazon Resource Names (ARN) of the resource shares. Defaults to None.
        next_token(str, optional): The token for the next page of results. Defaults to None.
        max_results(int, optional): The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned nextToken value. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ram.resource.init.list_all(ctx, resource_owner=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ram.resource.init.list_all resource_owner=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ram",
        operation="list_resources",
        op_kwargs={
            "resourceOwner": resource_owner,
            "principal": principal,
            "resourceType": resource_type,
            "resourceArns": resource_arns,
            "resourceShareArns": resource_share_arns,
            "nextToken": next_token,
            "maxResults": max_results,
        },
    )


async def tag(hub, ctx, resource_share_arn: str, tags: List) -> Dict:
    r"""
    **Autogenerated function**

    Adds the specified tags to the specified resource share that you own.

    Args:
        resource_share_arn(str): The Amazon Resource Name (ARN) of the resource share.
        tags(List): One or more tags.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ram.resource.init.tag(ctx, resource_share_arn=value, tags=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ram.resource.init.tag resource_share_arn=value, tags=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ram",
        operation="tag_resource",
        op_kwargs={"resourceShareArn": resource_share_arn, "tags": tags},
    )


async def untag(hub, ctx, resource_share_arn: str, tag_keys: List) -> Dict:
    r"""
    **Autogenerated function**

    Removes the specified tags from the specified resource share that you own.

    Args:
        resource_share_arn(str): The Amazon Resource Name (ARN) of the resource share.
        tag_keys(List): The tag keys of the tags to remove.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ram.resource.init.untag(
                ctx, resource_share_arn=value, tag_keys=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ram.resource.init.untag resource_share_arn=value, tag_keys=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ram",
        operation="untag_resource",
        op_kwargs={"resourceShareArn": resource_share_arn, "tagKeys": tag_keys},
    )
