"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def list_all(
    hub,
    ctx,
    resource_owner: str,
    resource_arn: str = None,
    principals: List = None,
    resource_type: str = None,
    resource_share_arns: List = None,
    next_token: str = None,
    max_results: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Lists the principals that you have shared resources with or that have shared resources with you.

    Args:
        resource_owner(str): The type of owner.
        resource_arn(str, optional): The Amazon Resource Name (ARN) of the resource. Defaults to None.
        principals(List, optional): The principals. Defaults to None.
        resource_type(str, optional): The resource type. Valid values: acm-pca:CertificateAuthority | appmesh:Mesh | codebuild:Project | codebuild:ReportGroup | ec2:CapacityReservation | ec2:DedicatedHost | ec2:LocalGatewayRouteTable | ec2:PrefixList | ec2:Subnet | ec2:TrafficMirrorTarget | ec2:TransitGateway | imagebuilder:Component | imagebuilder:Image | imagebuilder:ImageRecipe | imagebuilder:ContainerRecipe | glue:Catalog | glue:Database | glue:Table | license-manager:LicenseConfiguration I network-firewall:FirewallPolicy | network-firewall:StatefulRuleGroup | network-firewall:StatelessRuleGroup | outposts:Outpost | resource-groups:Group | rds:Cluster | route53resolver:ResolverQueryLogConfig | route53resolver:ResolverRule . Defaults to None.
        resource_share_arns(List, optional): The Amazon Resource Names (ARN) of the resource shares. Defaults to None.
        next_token(str, optional): The token for the next page of results. Defaults to None.
        max_results(int, optional): The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned nextToken value. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ram.principal.list_all(ctx, resource_owner=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ram.principal.list_all resource_owner=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ram",
        operation="list_principals",
        op_kwargs={
            "resourceOwner": resource_owner,
            "resourceArn": resource_arn,
            "principals": principals,
            "resourceType": resource_type,
            "resourceShareArns": resource_share_arns,
            "nextToken": next_token,
            "maxResults": max_results,
        },
    )
