"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(hub, ctx, permission_arn: str, permission_version: int = None) -> Dict:
    r"""
    **Autogenerated function**

    Gets the contents of an AWS RAM permission in JSON format.

    Args:
        permission_arn(str): The ARN of the permission.
        permission_version(int, optional): The identifier for the version of the permission. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ram.permission.get(ctx, permission_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ram.permission.get permission_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ram",
        operation="get_permission",
        op_kwargs={
            "permissionArn": permission_arn,
            "permissionVersion": permission_version,
        },
    )


async def list_all(
    hub, ctx, resource_type: str = None, next_token: str = None, max_results: int = None
) -> Dict:
    r"""
    **Autogenerated function**

    Lists the AWS RAM permissions.

    Args:
        resource_type(str, optional): Specifies the resource type for which to list permissions. For example, to list only permissions that apply to EC2 subnets, specify ec2:Subnet. Defaults to None.
        next_token(str, optional): The token for the next page of results. Defaults to None.
        max_results(int, optional): The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned nextToken value. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ram.permission.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ram.permission.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ram",
        operation="list_permissions",
        op_kwargs={
            "resourceType": resource_type,
            "nextToken": next_token,
            "maxResults": max_results,
        },
    )
