"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def list_all(
    hub,
    ctx,
    resource_share_invitation_arn: str,
    next_token: str = None,
    max_results: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Lists the resources in a resource share that is shared with you but that the invitation is still pending for.

    Args:
        resource_share_invitation_arn(str): The Amazon Resource Name (ARN) of the invitation.
        next_token(str, optional): The token for the next page of results. Defaults to None.
        max_results(int, optional): The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned nextToken value. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ram.pending_invitation_resource.list_all(
                ctx, resource_share_invitation_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ram.pending_invitation_resource.list_all resource_share_invitation_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ram",
        operation="list_pending_invitation_resources",
        op_kwargs={
            "resourceShareInvitationArn": resource_share_invitation_arn,
            "nextToken": next_token,
            "maxResults": max_results,
        },
    )
