"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def delete(hub, ctx, user_name: str, aws_account_id: str, namespace: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes the Amazon QuickSight user that is associated with the identity of the Identity and Access Management (IAM) user or role that's making the call. The IAM user isn't deleted as a result of this call.

    Args:
        user_name(str): The name of the user that you want to delete.
        aws_account_id(str): The ID for the Amazon Web Services account; that the user is in. Currently, you use the ID for the Amazon Web Services account; that contains your Amazon QuickSight account.
        namespace(str): The namespace. Currently, you should set this to default.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.quicksight.user.init.delete(
                ctx, user_name=value, aws_account_id=value, namespace=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.quicksight.user.init.delete user_name=value, aws_account_id=value, namespace=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="quicksight",
        operation="delete_user",
        op_kwargs={
            "UserName": user_name,
            "AwsAccountId": aws_account_id,
            "Namespace": namespace,
        },
    )


async def describe(
    hub, ctx, user_name: str, aws_account_id: str, namespace: str
) -> Dict:
    r"""
    **Autogenerated function**

    Returns information about a user, given the user name.

    Args:
        user_name(str): The name of the user that you want to describe.
        aws_account_id(str): The ID for the Amazon Web Services account; that the user is in. Currently, you use the ID for the Amazon Web Services account; that contains your Amazon QuickSight account.
        namespace(str): The namespace. Currently, you should set this to default.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.quicksight.user.init.describe(
                ctx, user_name=value, aws_account_id=value, namespace=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.quicksight.user.init.describe user_name=value, aws_account_id=value, namespace=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="quicksight",
        operation="describe_user",
        op_kwargs={
            "UserName": user_name,
            "AwsAccountId": aws_account_id,
            "Namespace": namespace,
        },
    )


async def list_all(
    hub,
    ctx,
    aws_account_id: str,
    namespace: str,
    next_token: str = None,
    max_results: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Returns a list of all of the Amazon QuickSight users belonging to this account.

    Args:
        aws_account_id(str): The ID for the Amazon Web Services account; that the user is in. Currently, you use the ID for the Amazon Web Services account; that contains your Amazon QuickSight account.
        next_token(str, optional): A pagination token that can be used in a subsequent request. Defaults to None.
        max_results(int, optional): The maximum number of results to return from this request. Defaults to None.
        namespace(str): The namespace. Currently, you should set this to default.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.quicksight.user.init.list_all(
                ctx, aws_account_id=value, namespace=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.quicksight.user.init.list_all aws_account_id=value, namespace=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="quicksight",
        operation="list_users",
        op_kwargs={
            "AwsAccountId": aws_account_id,
            "NextToken": next_token,
            "MaxResults": max_results,
            "Namespace": namespace,
        },
    )


async def register(
    hub,
    ctx,
    identity_type: str,
    email: str,
    user_role: str,
    aws_account_id: str,
    namespace: str,
    iam_arn: str = None,
    session_name: str = None,
    user_name: str = None,
    custom_permissions_name: str = None,
    external_login_federation_provider_type: str = None,
    custom_federation_provider_url: str = None,
    external_login_id: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates an Amazon QuickSight user, whose identity is associated with the AWS Identity and Access Management (IAM) identity or role specified in the request.

    Args:
        identity_type(str): Amazon QuickSight supports several ways of managing the identity of users. This parameter accepts two values:    IAM: A user whose identity maps to an existing IAM user or role.     QUICKSIGHT: A user whose identity is owned and managed internally by Amazon QuickSight.   .
        email(str): The email address of the user that you want to register.
        user_role(str): The Amazon QuickSight role for the user. The user role can be one of the following:    READER: A user who has read-only access to dashboards.    AUTHOR: A user who can create data sources, datasets, analyses, and dashboards.    ADMIN: A user who is an author, who can also manage Amazon QuickSight settings.    RESTRICTED_READER: This role isn't currently available for use.    RESTRICTED_AUTHOR: This role isn't currently available for use.  .
        iam_arn(str, optional): The ARN of the IAM user or role that you are registering with Amazon QuickSight. . Defaults to None.
        session_name(str, optional): You need to use this parameter only when you register one or more users using an assumed IAM role. You don't need to provide the session name for other scenarios, for example when you are registering an IAM user or an Amazon QuickSight user. You can register multiple users using the same IAM role if each user has a different session name. For more information on assuming IAM roles, see  assume-role  in the AWS CLI Reference. . Defaults to None.
        aws_account_id(str): The ID for the Amazon Web Services account; that the user is in. Currently, you use the ID for the Amazon Web Services account; that contains your Amazon QuickSight account.
        namespace(str): The namespace. Currently, you should set this to default.
        user_name(str, optional): The Amazon QuickSight user name that you want to create for the user you are registering. Defaults to None.
        custom_permissions_name(str, optional): (Enterprise edition only) The name of the custom permissions profile that you want to assign to this user. Customized permissions allows you to control a user's access by restricting access the following operations:   Create and update data sources   Create and update datasets   Create and update email reports   Subscribe to email reports   To add custom permissions to an existing user, use  UpdateUser  instead. A set of custom permissions includes any combination of these restrictions. Currently, you need to create the profile names for custom permission sets by using the QuickSight console. Then, you use the RegisterUser API operation to assign the named set of permissions to a QuickSight user.  QuickSight custom permissions are applied through IAM policies. Therefore, they override the permissions typically granted by assigning QuickSight users to one of the default security cohorts in QuickSight (admin, author, reader). This feature is available only to QuickSight Enterprise edition subscriptions. Defaults to None.
        external_login_federation_provider_type(str, optional): The type of supported external login provider that provides identity to let a user federate into Amazon QuickSight with an associated AWS Identity and Access Management (IAM) role. The type of supported external login provider can be one of the following.    COGNITO: Amazon Cognito. The provider URL is cognito-identity.amazonaws.com. When choosing the COGNITO provider type, don’t use the "CustomFederationProviderUrl" parameter which is only needed when the external provider is custom.    CUSTOM_OIDC: Custom OpenID Connect (OIDC) provider. When choosing CUSTOM_OIDC type, use the CustomFederationProviderUrl parameter to provide the custom OIDC provider URL.  . Defaults to None.
        custom_federation_provider_url(str, optional): The URL of the custom OpenID Connect (OIDC) provider that provides identity to let a user federate into QuickSight with an associated AWS Identity and Access Management (IAM) role. This parameter should only be used when ExternalLoginFederationProviderType parameter is set to CUSTOM_OIDC. Defaults to None.
        external_login_id(str, optional): The identity ID for a user in the external login provider. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.quicksight.user.init.register(
                ctx,
                identity_type=value,
                email=value,
                user_role=value,
                aws_account_id=value,
                namespace=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.quicksight.user.init.register identity_type=value, email=value, user_role=value, aws_account_id=value, namespace=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="quicksight",
        operation="register_user",
        op_kwargs={
            "IdentityType": identity_type,
            "Email": email,
            "UserRole": user_role,
            "IamArn": iam_arn,
            "SessionName": session_name,
            "AwsAccountId": aws_account_id,
            "Namespace": namespace,
            "UserName": user_name,
            "CustomPermissionsName": custom_permissions_name,
            "ExternalLoginFederationProviderType": external_login_federation_provider_type,
            "CustomFederationProviderUrl": custom_federation_provider_url,
            "ExternalLoginId": external_login_id,
        },
    )


async def update(
    hub,
    ctx,
    user_name: str,
    aws_account_id: str,
    namespace: str,
    email: str,
    role: str,
    custom_permissions_name: str = None,
    unapply_custom_permissions: bool = None,
    external_login_federation_provider_type: str = None,
    custom_federation_provider_url: str = None,
    external_login_id: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates an Amazon QuickSight user.

    Args:
        user_name(str): The Amazon QuickSight user name that you want to update.
        aws_account_id(str): The ID for the Amazon Web Services account; that the user is in. Currently, you use the ID for the Amazon Web Services account; that contains your Amazon QuickSight account.
        namespace(str): The namespace. Currently, you should set this to default.
        email(str): The email address of the user that you want to update.
        role(str): The Amazon QuickSight role of the user. The role can be one of the following default security cohorts:    READER: A user who has read-only access to dashboards.    AUTHOR: A user who can create data sources, datasets, analyses, and dashboards.    ADMIN: A user who is an author, who can also manage Amazon QuickSight settings.   The name of the QuickSight role is invisible to the user except for the console screens dealing with permissions.
        custom_permissions_name(str, optional): (Enterprise edition only) The name of the custom permissions profile that you want to assign to this user. Customized permissions allows you to control a user's access by restricting access the following operations:   Create and update data sources   Create and update datasets   Create and update email reports   Subscribe to email reports   A set of custom permissions includes any combination of these restrictions. Currently, you need to create the profile names for custom permission sets by using the QuickSight console. Then, you use the RegisterUser API operation to assign the named set of permissions to a QuickSight user.  QuickSight custom permissions are applied through IAM policies. Therefore, they override the permissions typically granted by assigning QuickSight users to one of the default security cohorts in QuickSight (admin, author, reader). This feature is available only to QuickSight Enterprise edition subscriptions. Defaults to None.
        unapply_custom_permissions(bool, optional): A flag that you use to indicate that you want to remove all custom permissions from this user. Using this parameter resets the user to the state it was in before a custom permissions profile was applied. This parameter defaults to NULL and it doesn't accept any other value. Defaults to None.
        external_login_federation_provider_type(str, optional): The type of supported external login provider that provides identity to let a user federate into QuickSight with an associated AWS Identity and Access Management (IAM) role. The type of supported external login provider can be one of the following.    COGNITO: Amazon Cognito. The provider URL is cognito-identity.amazonaws.com. When choosing the COGNITO provider type, don’t use the "CustomFederationProviderUrl" parameter which is only needed when the external provider is custom.    CUSTOM_OIDC: Custom OpenID Connect (OIDC) provider. When choosing CUSTOM_OIDC type, use the CustomFederationProviderUrl parameter to provide the custom OIDC provider URL.    NONE: This clears all the previously saved external login information for a user. Use  DescribeUser  API to check the external login information.  . Defaults to None.
        custom_federation_provider_url(str, optional): The URL of the custom OpenID Connect (OIDC) provider that provides identity to let a user federate into QuickSight with an associated AWS Identity and Access Management (IAM) role. This parameter should only be used when ExternalLoginFederationProviderType parameter is set to CUSTOM_OIDC. Defaults to None.
        external_login_id(str, optional): The identity ID for a user in the external login provider. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.quicksight.user.init.update(
                ctx, user_name=value, aws_account_id=value, namespace=value, email=value, role=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.quicksight.user.init.update user_name=value, aws_account_id=value, namespace=value, email=value, role=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="quicksight",
        operation="update_user",
        op_kwargs={
            "UserName": user_name,
            "AwsAccountId": aws_account_id,
            "Namespace": namespace,
            "Email": email,
            "Role": role,
            "CustomPermissionsName": custom_permissions_name,
            "UnapplyCustomPermissions": unapply_custom_permissions,
            "ExternalLoginFederationProviderType": external_login_federation_provider_type,
            "CustomFederationProviderUrl": custom_federation_provider_url,
            "ExternalLoginId": external_login_id,
        },
    )
