"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def list_all(
    hub,
    ctx,
    user_name: str,
    aws_account_id: str,
    namespace: str,
    next_token: str = None,
    max_results: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Lists the Amazon QuickSight groups that an Amazon QuickSight user is a member of.

    Args:
        user_name(str): The Amazon QuickSight user name that you want to list group memberships for.
        aws_account_id(str): The Amazon Web Services account; ID that the user is in. Currently, you use the ID for the Amazon Web Services account; that contains your Amazon QuickSight account.
        namespace(str): The namespace. Currently, you should set this to default.
        next_token(str, optional): A pagination token that can be used in a subsequent request. Defaults to None.
        max_results(int, optional): The maximum number of results to return from this request. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.quicksight.user.group.list_all(
                ctx, user_name=value, aws_account_id=value, namespace=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.quicksight.user.group.list_all user_name=value, aws_account_id=value, namespace=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="quicksight",
        operation="list_user_groups",
        op_kwargs={
            "UserName": user_name,
            "AwsAccountId": aws_account_id,
            "Namespace": namespace,
            "NextToken": next_token,
            "MaxResults": max_results,
        },
    )
