"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


__virtualname__ = "by_principal_id"


async def delete(
    hub, ctx, principal_id: str, aws_account_id: str, namespace: str
) -> Dict:
    r"""
    **Autogenerated function**

    Deletes a user identified by its principal ID.

    Args:
        principal_id(str): The principal ID of the user.
        aws_account_id(str): The ID for the Amazon Web Services account; that the user is in. Currently, you use the ID for the Amazon Web Services account; that contains your Amazon QuickSight account.
        namespace(str): The namespace. Currently, you should set this to default.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.quicksight.user.by_principal_id_.delete(
                ctx, principal_id=value, aws_account_id=value, namespace=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.quicksight.user.by_principal_id.delete principal_id=value, aws_account_id=value, namespace=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="quicksight",
        operation="delete_user_by_principal_id",
        op_kwargs={
            "PrincipalId": principal_id,
            "AwsAccountId": aws_account_id,
            "Namespace": namespace,
        },
    )
