"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def describe_all(hub, ctx, aws_account_id: str, theme_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Describes the read and write permissions for a theme.

    Args:
        aws_account_id(str): The ID of the Amazon Web Services account; that contains the theme that you're describing.
        theme_id(str): The ID for the theme that you want to describe permissions for.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.quicksight.theme.permission.describe_all(
                ctx, aws_account_id=value, theme_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.quicksight.theme.permission.describe_all aws_account_id=value, theme_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="quicksight",
        operation="describe_theme_permissions",
        op_kwargs={"AwsAccountId": aws_account_id, "ThemeId": theme_id},
    )


async def update_multiple(
    hub,
    ctx,
    aws_account_id: str,
    theme_id: str,
    grant_permissions: List = None,
    revoke_permissions: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates the resource permissions for a theme. Permissions apply to the action to grant or revoke permissions on, for example "quicksight:DescribeTheme". Theme permissions apply in groupings. Valid groupings include the following for the three levels of permissions, which are user, owner, or no permissions:    User    "quicksight:DescribeTheme"     "quicksight:DescribeThemeAlias"     "quicksight:ListThemeAliases"     "quicksight:ListThemeVersions"      Owner    "quicksight:DescribeTheme"     "quicksight:DescribeThemeAlias"     "quicksight:ListThemeAliases"     "quicksight:ListThemeVersions"     "quicksight:DeleteTheme"     "quicksight:UpdateTheme"     "quicksight:CreateThemeAlias"     "quicksight:DeleteThemeAlias"     "quicksight:UpdateThemeAlias"     "quicksight:UpdateThemePermissions"     "quicksight:DescribeThemePermissions"      To specify no permissions, omit the permissions list.

    Args:
        aws_account_id(str): The ID of the Amazon Web Services account; that contains the theme.
        theme_id(str): The ID for the theme.
        grant_permissions(List, optional): A list of resource permissions to be granted for the theme. Defaults to None.
        revoke_permissions(List, optional): A list of resource permissions to be revoked from the theme. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.quicksight.theme.permission.update_multiple(
                ctx, aws_account_id=value, theme_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.quicksight.theme.permission.update_multiple aws_account_id=value, theme_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="quicksight",
        operation="update_theme_permissions",
        op_kwargs={
            "AwsAccountId": aws_account_id,
            "ThemeId": theme_id,
            "GrantPermissions": grant_permissions,
            "RevokePermissions": revoke_permissions,
        },
    )
