"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    aws_account_id: str,
    theme_id: str,
    name: str,
    base_theme_id: str,
    configuration: Dict,
    version_description: str = None,
    permissions: List = None,
    tags: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a theme. A theme is set of configuration options for color and layout. Themes apply to analyses and dashboards. For more information, see Using Themes in Amazon QuickSight in the Amazon QuickSight User Guide.

    Args:
        aws_account_id(str): The ID of the Amazon Web Services account; where you want to store the new theme. .
        theme_id(str): An ID for the theme that you want to create. The theme ID is unique per Region; in each Amazon Web Services account;.
        name(str): A display name for the theme.
        base_theme_id(str): The ID of the theme that a custom theme will inherit from. All themes inherit from one of the starting themes defined by Amazon QuickSight. For a list of the starting themes, use ListThemes or choose Themes from within a QuickSight analysis. .
        version_description(str, optional): A description of the first version of the theme that you're creating. Every time UpdateTheme is called, a new version is created. Each version of the theme has a description of the version in the VersionDescription field. Defaults to None.
        configuration(Dict): The theme configuration, which contains the theme display properties.
        permissions(List, optional): A valid grouping of resource permissions to apply to the new theme. . Defaults to None.
        tags(List, optional): A map of the key-value pairs for the resource tag or tags that you want to add to the resource. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.quicksight.theme.init.create(
                ctx,
                aws_account_id=value,
                theme_id=value,
                name=value,
                base_theme_id=value,
                configuration=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.quicksight.theme.init.create aws_account_id=value, theme_id=value, name=value, base_theme_id=value, configuration=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="quicksight",
        operation="create_theme",
        op_kwargs={
            "AwsAccountId": aws_account_id,
            "ThemeId": theme_id,
            "Name": name,
            "BaseThemeId": base_theme_id,
            "VersionDescription": version_description,
            "Configuration": configuration,
            "Permissions": permissions,
            "Tags": tags,
        },
    )


async def delete(
    hub, ctx, aws_account_id: str, theme_id: str, version_number: int = None
) -> Dict:
    r"""
    **Autogenerated function**

    Deletes a theme.

    Args:
        aws_account_id(str): The ID of the Amazon Web Services account; that contains the theme that you're deleting.
        theme_id(str): An ID for the theme that you want to delete.
        version_number(int, optional): The version of the theme that you want to delete.   Note: If you don't provide a version number, you're using this call to DeleteTheme to delete all versions of the theme. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.quicksight.theme.init.delete(
                ctx, aws_account_id=value, theme_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.quicksight.theme.init.delete aws_account_id=value, theme_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="quicksight",
        operation="delete_theme",
        op_kwargs={
            "AwsAccountId": aws_account_id,
            "ThemeId": theme_id,
            "VersionNumber": version_number,
        },
    )


async def describe(
    hub,
    ctx,
    aws_account_id: str,
    theme_id: str,
    version_number: int = None,
    alias_name: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Describes a theme.

    Args:
        aws_account_id(str): The ID of the Amazon Web Services account; that contains the theme that you're describing.
        theme_id(str): The ID for the theme.
        version_number(int, optional): The version number for the version to describe. If a VersionNumber parameter value isn't provided, the latest version of the theme is described. Defaults to None.
        alias_name(str, optional): The alias of the theme that you want to describe. If you name a specific alias, you describe the version that the alias points to. You can specify the latest version of the theme by providing the keyword $LATEST in the AliasName parameter. The keyword $PUBLISHED doesn't apply to themes. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.quicksight.theme.init.describe(
                ctx, aws_account_id=value, theme_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.quicksight.theme.init.describe aws_account_id=value, theme_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="quicksight",
        operation="describe_theme",
        op_kwargs={
            "AwsAccountId": aws_account_id,
            "ThemeId": theme_id,
            "VersionNumber": version_number,
            "AliasName": alias_name,
        },
    )


async def list_all(
    hub,
    ctx,
    aws_account_id: str,
    next_token: str = None,
    max_results: int = None,
    type_: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Lists all the themes in the current Amazon Web Services account;.

    Args:
        aws_account_id(str): The ID of the Amazon Web Services account; that contains the themes that you're listing.
        next_token(str, optional): The token for the next set of results, or null if there are no more results. Defaults to None.
        max_results(int, optional): The maximum number of results to be returned per request. Defaults to None.
        type_(str, optional): The type of themes that you want to list. Valid options include the following:    ALL (default)- Display all existing themes.    CUSTOM - Display only the themes created by people using Amazon QuickSight.    QUICKSIGHT - Display only the starting themes defined by Amazon QuickSight.  . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.quicksight.theme.init.list_all(ctx, aws_account_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.quicksight.theme.init.list_all aws_account_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="quicksight",
        operation="list_themes",
        op_kwargs={
            "AwsAccountId": aws_account_id,
            "NextToken": next_token,
            "MaxResults": max_results,
            "Type": type_,
        },
    )


async def update(
    hub,
    ctx,
    aws_account_id: str,
    theme_id: str,
    base_theme_id: str,
    name: str = None,
    version_description: str = None,
    configuration: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates a theme.

    Args:
        aws_account_id(str): The ID of the Amazon Web Services account; that contains the theme that you're updating.
        theme_id(str): The ID for the theme.
        name(str, optional): The name for the theme. Defaults to None.
        base_theme_id(str): The theme ID, defined by Amazon QuickSight, that a custom theme inherits from. All themes initially inherit from a default Amazon QuickSight theme.
        version_description(str, optional): A description of the theme version that you're updating Every time that you call UpdateTheme, you create a new version of the theme. Each version of the theme maintains a description of the version in VersionDescription. Defaults to None.
        configuration(Dict, optional): The theme configuration, which contains the theme display properties. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.quicksight.theme.init.update(
                ctx, aws_account_id=value, theme_id=value, base_theme_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.quicksight.theme.init.update aws_account_id=value, theme_id=value, base_theme_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="quicksight",
        operation="update_theme",
        op_kwargs={
            "AwsAccountId": aws_account_id,
            "ThemeId": theme_id,
            "Name": name,
            "BaseThemeId": base_theme_id,
            "VersionDescription": version_description,
            "Configuration": configuration,
        },
    )
