"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(
    hub,
    ctx,
    aws_account_id: str,
    theme_id: str,
    alias_name: str,
    theme_version_number: int,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a theme alias for a theme.

    Args:
        aws_account_id(str): The ID of the Amazon Web Services account; that contains the theme for the new theme alias.
        theme_id(str): An ID for the theme alias.
        alias_name(str): The name that you want to give to the theme alias that you are creating. The alias name can't begin with a $. Alias names that start with $ are reserved by Amazon QuickSight. .
        theme_version_number(int): The version number of the theme.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.quicksight.theme.alias.create(
                ctx,
                aws_account_id=value,
                theme_id=value,
                alias_name=value,
                theme_version_number=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.quicksight.theme.alias.create aws_account_id=value, theme_id=value, alias_name=value, theme_version_number=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="quicksight",
        operation="create_theme_alias",
        op_kwargs={
            "AwsAccountId": aws_account_id,
            "ThemeId": theme_id,
            "AliasName": alias_name,
            "ThemeVersionNumber": theme_version_number,
        },
    )


async def delete(hub, ctx, aws_account_id: str, theme_id: str, alias_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes the version of the theme that the specified theme alias points to. If you provide a specific alias, you delete the version of the theme that the alias points to.

    Args:
        aws_account_id(str): The ID of the Amazon Web Services account; that contains the theme alias to delete.
        theme_id(str): The ID for the theme that the specified alias is for.
        alias_name(str): The unique name for the theme alias to delete.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.quicksight.theme.alias.delete(
                ctx, aws_account_id=value, theme_id=value, alias_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.quicksight.theme.alias.delete aws_account_id=value, theme_id=value, alias_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="quicksight",
        operation="delete_theme_alias",
        op_kwargs={
            "AwsAccountId": aws_account_id,
            "ThemeId": theme_id,
            "AliasName": alias_name,
        },
    )


async def describe(
    hub, ctx, aws_account_id: str, theme_id: str, alias_name: str
) -> Dict:
    r"""
    **Autogenerated function**

    Describes the alias for a theme.

    Args:
        aws_account_id(str): The ID of the Amazon Web Services account; that contains the theme alias that you're describing.
        theme_id(str): The ID for the theme.
        alias_name(str): The name of the theme alias that you want to describe.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.quicksight.theme.alias.describe(
                ctx, aws_account_id=value, theme_id=value, alias_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.quicksight.theme.alias.describe aws_account_id=value, theme_id=value, alias_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="quicksight",
        operation="describe_theme_alias",
        op_kwargs={
            "AwsAccountId": aws_account_id,
            "ThemeId": theme_id,
            "AliasName": alias_name,
        },
    )


async def update(
    hub,
    ctx,
    aws_account_id: str,
    theme_id: str,
    alias_name: str,
    theme_version_number: int,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates an alias of a theme.

    Args:
        aws_account_id(str): The ID of the Amazon Web Services account; that contains the theme alias that you're updating.
        theme_id(str): The ID for the theme.
        alias_name(str): The name of the theme alias that you want to update.
        theme_version_number(int): The version number of the theme that the alias should reference.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.quicksight.theme.alias.update(
                ctx,
                aws_account_id=value,
                theme_id=value,
                alias_name=value,
                theme_version_number=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.quicksight.theme.alias.update aws_account_id=value, theme_id=value, alias_name=value, theme_version_number=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="quicksight",
        operation="update_theme_alias",
        op_kwargs={
            "AwsAccountId": aws_account_id,
            "ThemeId": theme_id,
            "AliasName": alias_name,
            "ThemeVersionNumber": theme_version_number,
        },
    )
