"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    aws_account_id: str,
    template_id: str,
    source_entity: Dict,
    name: str = None,
    permissions: List = None,
    tags: List = None,
    version_description: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a template from an existing Amazon QuickSight analysis or template. You can use the resulting template to create a dashboard. A template is an entity in QuickSight that encapsulates the metadata required to create an analysis and that you can use to create s dashboard. A template adds a layer of abstraction by using placeholders to replace the dataset associated with the analysis. You can use templates to create dashboards by replacing dataset placeholders with datasets that follow the same schema that was used to create the source analysis and template.

    Args:
        aws_account_id(str): The ID for the Amazon Web Services account; that the group is in. Currently, you use the ID for the Amazon Web Services account; that contains your Amazon QuickSight account.
        template_id(str): An ID for the template that you want to create. This template is unique per Region; in each Amazon Web Services account;.
        name(str, optional): A display name for the template. Defaults to None.
        permissions(List, optional): A list of resource permissions to be set on the template. . Defaults to None.
        source_entity(Dict): The entity that you are using as a source when you create the template. In SourceEntity, you specify the type of object you're using as source: SourceTemplate for a template or SourceAnalysis for an analysis. Both of these require an Amazon Resource Name (ARN). For SourceTemplate, specify the ARN of the source template. For SourceAnalysis, specify the ARN of the source analysis. The SourceTemplate ARN can contain any Amazon Web Services account; and any QuickSight-supported Region;.  Use the DataSetReferences entity within SourceTemplate or SourceAnalysis to list the replacement datasets for the placeholders listed in the original. The schema in each dataset must match its placeholder. .
        tags(List, optional): Contains a map of the key-value pairs for the resource tag or tags assigned to the resource. Defaults to None.
        version_description(str, optional): A description of the current template version being created. This API operation creates the first version of the template. Every time UpdateTemplate is called, a new version is created. Each version of the template maintains a description of the version in the VersionDescription field. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.quicksight.template.init.create(
                ctx, aws_account_id=value, template_id=value, source_entity=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.quicksight.template.init.create aws_account_id=value, template_id=value, source_entity=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="quicksight",
        operation="create_template",
        op_kwargs={
            "AwsAccountId": aws_account_id,
            "TemplateId": template_id,
            "Name": name,
            "Permissions": permissions,
            "SourceEntity": source_entity,
            "Tags": tags,
            "VersionDescription": version_description,
        },
    )


async def delete(
    hub, ctx, aws_account_id: str, template_id: str, version_number: int = None
) -> Dict:
    r"""
    **Autogenerated function**

    Deletes a template.

    Args:
        aws_account_id(str): The ID of the Amazon Web Services account; that contains the template that you're deleting.
        template_id(str): An ID for the template you want to delete.
        version_number(int, optional): Specifies the version of the template that you want to delete. If you don't provide a version number, DeleteTemplate deletes all versions of the template. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.quicksight.template.init.delete(
                ctx, aws_account_id=value, template_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.quicksight.template.init.delete aws_account_id=value, template_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="quicksight",
        operation="delete_template",
        op_kwargs={
            "AwsAccountId": aws_account_id,
            "TemplateId": template_id,
            "VersionNumber": version_number,
        },
    )


async def describe(
    hub,
    ctx,
    aws_account_id: str,
    template_id: str,
    version_number: int = None,
    alias_name: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Describes a template's metadata.

    Args:
        aws_account_id(str): The ID of the Amazon Web Services account; that contains the template that you're describing.
        template_id(str): The ID for the template.
        version_number(int, optional): (Optional) The number for the version to describe. If a VersionNumber parameter value isn't provided, the latest version of the template is described. Defaults to None.
        alias_name(str, optional): The alias of the template that you want to describe. If you name a specific alias, you describe the version that the alias points to. You can specify the latest version of the template by providing the keyword $LATEST in the AliasName parameter. The keyword $PUBLISHED doesn't apply to templates. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.quicksight.template.init.describe(
                ctx, aws_account_id=value, template_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.quicksight.template.init.describe aws_account_id=value, template_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="quicksight",
        operation="describe_template",
        op_kwargs={
            "AwsAccountId": aws_account_id,
            "TemplateId": template_id,
            "VersionNumber": version_number,
            "AliasName": alias_name,
        },
    )


async def list_all(
    hub, ctx, aws_account_id: str, next_token: str = None, max_results: int = None
) -> Dict:
    r"""
    **Autogenerated function**

    Lists all the templates in the current Amazon QuickSight account.

    Args:
        aws_account_id(str): The ID of the Amazon Web Services account; that contains the templates that you're listing.
        next_token(str, optional): The token for the next set of results, or null if there are no more results. Defaults to None.
        max_results(int, optional): The maximum number of results to be returned per request. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.quicksight.template.init.list_all(ctx, aws_account_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.quicksight.template.init.list_all aws_account_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="quicksight",
        operation="list_templates",
        op_kwargs={
            "AwsAccountId": aws_account_id,
            "NextToken": next_token,
            "MaxResults": max_results,
        },
    )


async def update(
    hub,
    ctx,
    aws_account_id: str,
    template_id: str,
    source_entity: Dict,
    version_description: str = None,
    name: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates a template from an existing Amazon QuickSight analysis or another template.

    Args:
        aws_account_id(str): The ID of the Amazon Web Services account; that contains the template that you're updating.
        template_id(str): The ID for the template.
        source_entity(Dict): The entity that you are using as a source when you update the template. In SourceEntity, you specify the type of object you're using as source: SourceTemplate for a template or SourceAnalysis for an analysis. Both of these require an Amazon Resource Name (ARN). For SourceTemplate, specify the ARN of the source template. For SourceAnalysis, specify the ARN of the source analysis. The SourceTemplate ARN can contain any Amazon Web Services account; and any QuickSight-supported Region;.  Use the DataSetReferences entity within SourceTemplate or SourceAnalysis to list the replacement datasets for the placeholders listed in the original. The schema in each dataset must match its placeholder. .
        version_description(str, optional): A description of the current template version that is being updated. Every time you call UpdateTemplate, you create a new version of the template. Each version of the template maintains a description of the version in the VersionDescription field. Defaults to None.
        name(str, optional): The name for the template. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.quicksight.template.init.update(
                ctx, aws_account_id=value, template_id=value, source_entity=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.quicksight.template.init.update aws_account_id=value, template_id=value, source_entity=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="quicksight",
        operation="update_template",
        op_kwargs={
            "AwsAccountId": aws_account_id,
            "TemplateId": template_id,
            "SourceEntity": source_entity,
            "VersionDescription": version_description,
            "Name": name,
        },
    )
