"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(
    hub,
    ctx,
    aws_account_id: str,
    template_id: str,
    alias_name: str,
    template_version_number: int,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a template alias for a template.

    Args:
        aws_account_id(str): The ID of the Amazon Web Services account; that contains the template that you creating an alias for.
        template_id(str): An ID for the template.
        alias_name(str): The name that you want to give to the template alias that you're creating. Don't start the alias name with the $ character. Alias names that start with $ are reserved by Amazon QuickSight. .
        template_version_number(int): The version number of the template.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.quicksight.template.alias.create(
                ctx,
                aws_account_id=value,
                template_id=value,
                alias_name=value,
                template_version_number=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.quicksight.template.alias.create aws_account_id=value, template_id=value, alias_name=value, template_version_number=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="quicksight",
        operation="create_template_alias",
        op_kwargs={
            "AwsAccountId": aws_account_id,
            "TemplateId": template_id,
            "AliasName": alias_name,
            "TemplateVersionNumber": template_version_number,
        },
    )


async def delete(
    hub, ctx, aws_account_id: str, template_id: str, alias_name: str
) -> Dict:
    r"""
    **Autogenerated function**

    Deletes the item that the specified template alias points to. If you provide a specific alias, you delete the version of the template that the alias points to.

    Args:
        aws_account_id(str): The ID of the Amazon Web Services account; that contains the item to delete.
        template_id(str): The ID for the template that the specified alias is for.
        alias_name(str): The name for the template alias. To delete a specific alias, you delete the version that the alias points to. You can specify the alias name, or specify the latest version of the template by providing the keyword $LATEST in the AliasName parameter. .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.quicksight.template.alias.delete(
                ctx, aws_account_id=value, template_id=value, alias_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.quicksight.template.alias.delete aws_account_id=value, template_id=value, alias_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="quicksight",
        operation="delete_template_alias",
        op_kwargs={
            "AwsAccountId": aws_account_id,
            "TemplateId": template_id,
            "AliasName": alias_name,
        },
    )


async def describe(
    hub, ctx, aws_account_id: str, template_id: str, alias_name: str
) -> Dict:
    r"""
    **Autogenerated function**

    Describes the template alias for a template.

    Args:
        aws_account_id(str): The ID of the Amazon Web Services account; that contains the template alias that you're describing.
        template_id(str): The ID for the template.
        alias_name(str): The name of the template alias that you want to describe. If you name a specific alias, you describe the version that the alias points to. You can specify the latest version of the template by providing the keyword $LATEST in the AliasName parameter. The keyword $PUBLISHED doesn't apply to templates.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.quicksight.template.alias.describe(
                ctx, aws_account_id=value, template_id=value, alias_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.quicksight.template.alias.describe aws_account_id=value, template_id=value, alias_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="quicksight",
        operation="describe_template_alias",
        op_kwargs={
            "AwsAccountId": aws_account_id,
            "TemplateId": template_id,
            "AliasName": alias_name,
        },
    )


async def update(
    hub,
    ctx,
    aws_account_id: str,
    template_id: str,
    alias_name: str,
    template_version_number: int,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates the template alias of a template.

    Args:
        aws_account_id(str): The ID of the Amazon Web Services account; that contains the template alias that you're updating.
        template_id(str): The ID for the template.
        alias_name(str): The alias of the template that you want to update. If you name a specific alias, you update the version that the alias points to. You can specify the latest version of the template by providing the keyword $LATEST in the AliasName parameter. The keyword $PUBLISHED doesn't apply to templates.
        template_version_number(int): The version number of the template.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.quicksight.template.alias.update(
                ctx,
                aws_account_id=value,
                template_id=value,
                alias_name=value,
                template_version_number=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.quicksight.template.alias.update aws_account_id=value, template_id=value, alias_name=value, template_version_number=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="quicksight",
        operation="update_template_alias",
        op_kwargs={
            "AwsAccountId": aws_account_id,
            "TemplateId": template_id,
            "AliasName": alias_name,
            "TemplateVersionNumber": template_version_number,
        },
    )
