"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    aws_account_id: str,
    namespace: str,
    identity_store: str,
    tags: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    (Enterprise edition only) Creates a new namespace for you to use with Amazon QuickSight. A namespace allows you to isolate the QuickSight users and groups that are registered for that namespace. Users that access the namespace can share assets only with other users or groups in the same namespace. They can't see users and groups in other namespaces. You can create a namespace after your Amazon Web Services account; is subscribed to QuickSight. The namespace must be unique within the Amazon Web Services account;. By default, there is a limit of 100 namespaces per Amazon Web Services account;. To increase your limit, create a ticket with Amazon Web Services Support.

    Args:
        aws_account_id(str): The ID for the Amazon Web Services account; that you want to create the QuickSight namespace in.
        namespace(str): The name that you want to use to describe the new namespace.
        identity_store(str): Specifies the type of your user identity directory. Currently, this supports users with an identity type of QUICKSIGHT.
        tags(List, optional): The tags that you want to associate with the namespace that you're creating. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.quicksight.namespace.create(
                ctx, aws_account_id=value, namespace=value, identity_store=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.quicksight.namespace.create aws_account_id=value, namespace=value, identity_store=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="quicksight",
        operation="create_namespace",
        op_kwargs={
            "AwsAccountId": aws_account_id,
            "Namespace": namespace,
            "IdentityStore": identity_store,
            "Tags": tags,
        },
    )


async def delete(hub, ctx, aws_account_id: str, namespace: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes a namespace and the users and groups that are associated with the namespace. This is an asynchronous process. Assets including dashboards, analyses, datasets and data sources are not deleted. To delete these assets, you use the API operations for the relevant asset.

    Args:
        aws_account_id(str): The ID for the Amazon Web Services account; that you want to delete the QuickSight namespace from.
        namespace(str): The namespace that you want to delete.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.quicksight.namespace.delete(
                ctx, aws_account_id=value, namespace=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.quicksight.namespace.delete aws_account_id=value, namespace=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="quicksight",
        operation="delete_namespace",
        op_kwargs={"AwsAccountId": aws_account_id, "Namespace": namespace},
    )


async def describe(hub, ctx, aws_account_id: str, namespace: str) -> Dict:
    r"""
    **Autogenerated function**

    Describes the current namespace.

    Args:
        aws_account_id(str): The ID for the Amazon Web Services account; that contains the QuickSight namespace that you want to describe.
        namespace(str): The namespace that you want to describe.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.quicksight.namespace.describe(
                ctx, aws_account_id=value, namespace=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.quicksight.namespace.describe aws_account_id=value, namespace=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="quicksight",
        operation="describe_namespace",
        op_kwargs={"AwsAccountId": aws_account_id, "Namespace": namespace},
    )


async def list_all(
    hub, ctx, aws_account_id: str, next_token: str = None, max_results: int = None
) -> Dict:
    r"""
    **Autogenerated function**

    Lists the namespaces for the specified Amazon Web Services account;.

    Args:
        aws_account_id(str): The ID for the Amazon Web Services account; that contains the QuickSight namespaces that you want to list.
        next_token(str, optional): A pagination token that can be used in a subsequent request. Defaults to None.
        max_results(int, optional): The maximum number of results to return. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.quicksight.namespace.list_all(ctx, aws_account_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.quicksight.namespace.list_all aws_account_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="quicksight",
        operation="list_namespaces",
        op_kwargs={
            "AwsAccountId": aws_account_id,
            "NextToken": next_token,
            "MaxResults": max_results,
        },
    )
