"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def cancel(
    hub, ctx, aws_account_id: str, data_set_id: str, ingestion_id: str
) -> Dict:
    r"""
    **Autogenerated function**

    Cancels an ongoing ingestion of data into SPICE.

    Args:
        aws_account_id(str): The Amazon Web Services account; ID.
        data_set_id(str): The ID of the dataset used in the ingestion.
        ingestion_id(str): An ID for the ingestion.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.quicksight.ingestion.cancel(
                ctx, aws_account_id=value, data_set_id=value, ingestion_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.quicksight.ingestion.cancel aws_account_id=value, data_set_id=value, ingestion_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="quicksight",
        operation="cancel_ingestion",
        op_kwargs={
            "AwsAccountId": aws_account_id,
            "DataSetId": data_set_id,
            "IngestionId": ingestion_id,
        },
    )


async def create(
    hub, ctx, data_set_id: str, ingestion_id: str, aws_account_id: str
) -> Dict:
    r"""
    **Autogenerated function**

    Creates and starts a new SPICE ingestion on a dataset Any ingestions operating on tagged datasets inherit the same tags automatically for use in access control. For an example, see How do I create an IAM policy to control access to Amazon EC2 resources using tags? in the Amazon Web Services Knowledge Center. Tags are visible on the tagged dataset, but not on the ingestion resource.

    Args:
        data_set_id(str): The ID of the dataset used in the ingestion.
        ingestion_id(str): An ID for the ingestion.
        aws_account_id(str): The Amazon Web Services account; ID.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.quicksight.ingestion.create(
                ctx, data_set_id=value, ingestion_id=value, aws_account_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.quicksight.ingestion.create data_set_id=value, ingestion_id=value, aws_account_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="quicksight",
        operation="create_ingestion",
        op_kwargs={
            "DataSetId": data_set_id,
            "IngestionId": ingestion_id,
            "AwsAccountId": aws_account_id,
        },
    )


async def describe(
    hub, ctx, aws_account_id: str, data_set_id: str, ingestion_id: str
) -> Dict:
    r"""
    **Autogenerated function**

    Describes a SPICE ingestion.

    Args:
        aws_account_id(str): The Amazon Web Services account; ID.
        data_set_id(str): The ID of the dataset used in the ingestion.
        ingestion_id(str): An ID for the ingestion.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.quicksight.ingestion.describe(
                ctx, aws_account_id=value, data_set_id=value, ingestion_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.quicksight.ingestion.describe aws_account_id=value, data_set_id=value, ingestion_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="quicksight",
        operation="describe_ingestion",
        op_kwargs={
            "AwsAccountId": aws_account_id,
            "DataSetId": data_set_id,
            "IngestionId": ingestion_id,
        },
    )


async def list_all(
    hub,
    ctx,
    data_set_id: str,
    aws_account_id: str,
    next_token: str = None,
    max_results: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Lists the history of SPICE ingestions for a dataset.

    Args:
        data_set_id(str): The ID of the dataset used in the ingestion.
        next_token(str, optional): The token for the next set of results, or null if there are no more results. Defaults to None.
        aws_account_id(str): The Amazon Web Services account; ID.
        max_results(int, optional): The maximum number of results to be returned per request. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.quicksight.ingestion.list_all(
                ctx, data_set_id=value, aws_account_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.quicksight.ingestion.list_all data_set_id=value, aws_account_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="quicksight",
        operation="list_ingestions",
        op_kwargs={
            "DataSetId": data_set_id,
            "NextToken": next_token,
            "AwsAccountId": aws_account_id,
            "MaxResults": max_results,
        },
    )
