"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(
    hub,
    ctx,
    aws_account_id: str,
    assignment_name: str,
    assignment_status: str,
    namespace: str,
    policy_arn: str = None,
    identities: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates an assignment with one specified IAM policy, identified by its Amazon Resource Name (ARN). This policy assignment is attached to the specified groups or users of Amazon QuickSight. Assignment names are unique per Amazon Web Services account;. To avoid overwriting rules in other namespaces, use assignment names that are unique.

    Args:
        aws_account_id(str): The ID of the Amazon Web Services account; where you want to assign an IAM policy to QuickSight users or groups.
        assignment_name(str): The name of the assignment, also called a rule. It must be unique within an Amazon Web Services account;.
        assignment_status(str): The status of the assignment. Possible values are as follows:    ENABLED - Anything specified in this assignment is used when creating the data source.    DISABLED - This assignment isn't used when creating the data source.    DRAFT - This assignment is an unfinished draft and isn't used when creating the data source.  .
        policy_arn(str, optional): The ARN for the IAM policy to apply to the QuickSight users and groups specified in this assignment. Defaults to None.
        identities(Dict, optional): The QuickSight users, groups, or both that you want to assign the policy to. Defaults to None.
        namespace(str): The namespace that contains the assignment.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.quicksight.iam_policy_assignment.init.create(
                ctx,
                aws_account_id=value,
                assignment_name=value,
                assignment_status=value,
                namespace=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.quicksight.iam_policy_assignment.init.create aws_account_id=value, assignment_name=value, assignment_status=value, namespace=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="quicksight",
        operation="create_iam_policy_assignment",
        op_kwargs={
            "AwsAccountId": aws_account_id,
            "AssignmentName": assignment_name,
            "AssignmentStatus": assignment_status,
            "PolicyArn": policy_arn,
            "Identities": identities,
            "Namespace": namespace,
        },
    )


async def delete(
    hub, ctx, aws_account_id: str, assignment_name: str, namespace: str
) -> Dict:
    r"""
    **Autogenerated function**

    Deletes an existing IAM policy assignment.

    Args:
        aws_account_id(str): The Amazon Web Services account; ID where you want to delete the IAM policy assignment.
        assignment_name(str): The name of the assignment. .
        namespace(str): The namespace that contains the assignment.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.quicksight.iam_policy_assignment.init.delete(
                ctx, aws_account_id=value, assignment_name=value, namespace=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.quicksight.iam_policy_assignment.init.delete aws_account_id=value, assignment_name=value, namespace=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="quicksight",
        operation="delete_iam_policy_assignment",
        op_kwargs={
            "AwsAccountId": aws_account_id,
            "AssignmentName": assignment_name,
            "Namespace": namespace,
        },
    )


async def describe(
    hub, ctx, aws_account_id: str, assignment_name: str, namespace: str
) -> Dict:
    r"""
    **Autogenerated function**

    Describes an existing IAM policy assignment, as specified by the assignment name.

    Args:
        aws_account_id(str): The ID of the Amazon Web Services account; that contains the assignment that you want to describe.
        assignment_name(str): The name of the assignment, also called a rule.
        namespace(str): The namespace that contains the assignment.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.quicksight.iam_policy_assignment.init.describe(
                ctx, aws_account_id=value, assignment_name=value, namespace=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.quicksight.iam_policy_assignment.init.describe aws_account_id=value, assignment_name=value, namespace=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="quicksight",
        operation="describe_iam_policy_assignment",
        op_kwargs={
            "AwsAccountId": aws_account_id,
            "AssignmentName": assignment_name,
            "Namespace": namespace,
        },
    )


async def list_all(
    hub,
    ctx,
    aws_account_id: str,
    namespace: str,
    assignment_status: str = None,
    next_token: str = None,
    max_results: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Lists IAM policy assignments in the current Amazon QuickSight account.

    Args:
        aws_account_id(str): The ID of the Amazon Web Services account; that contains these IAM policy assignments.
        assignment_status(str, optional): The status of the assignments. Defaults to None.
        namespace(str): The namespace for the assignments.
        next_token(str, optional): The token for the next set of results, or null if there are no more results. Defaults to None.
        max_results(int, optional): The maximum number of results to be returned per request. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.quicksight.iam_policy_assignment.init.list_all(
                ctx, aws_account_id=value, namespace=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.quicksight.iam_policy_assignment.init.list_all aws_account_id=value, namespace=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="quicksight",
        operation="list_iam_policy_assignments",
        op_kwargs={
            "AwsAccountId": aws_account_id,
            "AssignmentStatus": assignment_status,
            "Namespace": namespace,
            "NextToken": next_token,
            "MaxResults": max_results,
        },
    )


async def update(
    hub,
    ctx,
    aws_account_id: str,
    assignment_name: str,
    namespace: str,
    assignment_status: str = None,
    policy_arn: str = None,
    identities: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates an existing IAM policy assignment. This operation updates only the optional parameter or parameters that are specified in the request. This overwrites all of the users included in Identities.

    Args:
        aws_account_id(str): The ID of the Amazon Web Services account; that contains the IAM policy assignment. .
        assignment_name(str): The name of the assignment, also called a rule. This name must be unique within an Amazon Web Services account;.
        namespace(str): The namespace of the assignment.
        assignment_status(str, optional): The status of the assignment. Possible values are as follows:    ENABLED - Anything specified in this assignment is used when creating the data source.    DISABLED - This assignment isn't used when creating the data source.    DRAFT - This assignment is an unfinished draft and isn't used when creating the data source.  . Defaults to None.
        policy_arn(str, optional): The ARN for the IAM policy to apply to the QuickSight users and groups specified in this assignment. Defaults to None.
        identities(Dict, optional): The QuickSight users, groups, or both that you want to assign the policy to. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.quicksight.iam_policy_assignment.init.update(
                ctx, aws_account_id=value, assignment_name=value, namespace=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.quicksight.iam_policy_assignment.init.update aws_account_id=value, assignment_name=value, namespace=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="quicksight",
        operation="update_iam_policy_assignment",
        op_kwargs={
            "AwsAccountId": aws_account_id,
            "AssignmentName": assignment_name,
            "Namespace": namespace,
            "AssignmentStatus": assignment_status,
            "PolicyArn": policy_arn,
            "Identities": identities,
        },
    )
