"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


__func_alias__ = {"list_": "list"}


async def list_(
    hub,
    ctx,
    aws_account_id: str,
    user_name: str,
    namespace: str,
    next_token: str = None,
    max_results: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Lists all the IAM policy assignments, including the Amazon Resource Names (ARNs) for the IAM policies assigned to the specified user and group or groups that the user belongs to.

    Args:
        aws_account_id(str): The ID of the Amazon Web Services account; that contains the assignments.
        user_name(str): The name of the user.
        next_token(str, optional): The token for the next set of results, or null if there are no more results. Defaults to None.
        max_results(int, optional): The maximum number of results to be returned per request. Defaults to None.
        namespace(str): The namespace of the assignment.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.quicksight.iam_policy_assignment.for_user.list(
                ctx, aws_account_id=value, user_name=value, namespace=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.quicksight.iam_policy_assignment.for_user.list aws_account_id=value, user_name=value, namespace=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="quicksight",
        operation="list_iam_policy_assignments_for_user",
        op_kwargs={
            "AwsAccountId": aws_account_id,
            "UserName": user_name,
            "NextToken": next_token,
            "MaxResults": max_results,
            "Namespace": namespace,
        },
    )
