"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(
    hub, ctx, member_name: str, group_name: str, aws_account_id: str, namespace: str
) -> Dict:
    r"""
    **Autogenerated function**

    Adds an Amazon QuickSight user to an Amazon QuickSight group.

    Args:
        member_name(str): The name of the user that you want to add to the group membership.
        group_name(str): The name of the group that you want to add the user to.
        aws_account_id(str): The ID for the Amazon Web Services account; that the group is in. Currently, you use the ID for the Amazon Web Services account; that contains your Amazon QuickSight account.
        namespace(str): The namespace. Currently, you should set this to default.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.quicksight.group.membership.create(
                ctx, member_name=value, group_name=value, aws_account_id=value, namespace=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.quicksight.group.membership.create member_name=value, group_name=value, aws_account_id=value, namespace=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="quicksight",
        operation="create_group_membership",
        op_kwargs={
            "MemberName": member_name,
            "GroupName": group_name,
            "AwsAccountId": aws_account_id,
            "Namespace": namespace,
        },
    )


async def delete(
    hub, ctx, member_name: str, group_name: str, aws_account_id: str, namespace: str
) -> Dict:
    r"""
    **Autogenerated function**

    Removes a user from a group so that the user is no longer a member of the group.

    Args:
        member_name(str): The name of the user that you want to delete from the group membership.
        group_name(str): The name of the group that you want to delete the user from.
        aws_account_id(str): The ID for the Amazon Web Services account; that the group is in. Currently, you use the ID for the Amazon Web Services account; that contains your Amazon QuickSight account.
        namespace(str): The namespace. Currently, you should set this to default.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.quicksight.group.membership.delete(
                ctx, member_name=value, group_name=value, aws_account_id=value, namespace=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.quicksight.group.membership.delete member_name=value, group_name=value, aws_account_id=value, namespace=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="quicksight",
        operation="delete_group_membership",
        op_kwargs={
            "MemberName": member_name,
            "GroupName": group_name,
            "AwsAccountId": aws_account_id,
            "Namespace": namespace,
        },
    )


async def list_all(
    hub,
    ctx,
    group_name: str,
    aws_account_id: str,
    namespace: str,
    next_token: str = None,
    max_results: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Lists member users in a group.

    Args:
        group_name(str): The name of the group that you want to see a membership list of.
        next_token(str, optional): A pagination token that can be used in a subsequent request. Defaults to None.
        max_results(int, optional): The maximum number of results to return from this request. Defaults to None.
        aws_account_id(str): The ID for the Amazon Web Services account; that the group is in. Currently, you use the ID for the Amazon Web Services account; that contains your Amazon QuickSight account.
        namespace(str): The namespace. Currently, you should set this to default.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.quicksight.group.membership.list_all(
                ctx, group_name=value, aws_account_id=value, namespace=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.quicksight.group.membership.list_all group_name=value, aws_account_id=value, namespace=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="quicksight",
        operation="list_group_memberships",
        op_kwargs={
            "GroupName": group_name,
            "NextToken": next_token,
            "MaxResults": max_results,
            "AwsAccountId": aws_account_id,
            "Namespace": namespace,
        },
    )
