"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(
    hub,
    ctx,
    group_name: str,
    aws_account_id: str,
    namespace: str,
    description: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates an Amazon QuickSight group. The permissions resource is arn:aws:quicksight:us-east-1:<relevant-aws-account-id>:group/default/<group-name> . The response is a group object.

    Args:
        group_name(str): A name for the group that you want to create.
        description(str, optional): A description for the group that you want to create. Defaults to None.
        aws_account_id(str): The ID for the Amazon Web Services account; that the group is in. Currently, you use the ID for the Amazon Web Services account; that contains your Amazon QuickSight account.
        namespace(str): The namespace. Currently, you should set this to default.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.quicksight.group.init.create(
                ctx, group_name=value, aws_account_id=value, namespace=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.quicksight.group.init.create group_name=value, aws_account_id=value, namespace=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="quicksight",
        operation="create_group",
        op_kwargs={
            "GroupName": group_name,
            "Description": description,
            "AwsAccountId": aws_account_id,
            "Namespace": namespace,
        },
    )


async def delete(
    hub, ctx, group_name: str, aws_account_id: str, namespace: str
) -> Dict:
    r"""
    **Autogenerated function**

    Removes a user group from Amazon QuickSight.

    Args:
        group_name(str): The name of the group that you want to delete.
        aws_account_id(str): The ID for the Amazon Web Services account; that the group is in. Currently, you use the ID for the Amazon Web Services account; that contains your Amazon QuickSight account.
        namespace(str): The namespace. Currently, you should set this to default.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.quicksight.group.init.delete(
                ctx, group_name=value, aws_account_id=value, namespace=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.quicksight.group.init.delete group_name=value, aws_account_id=value, namespace=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="quicksight",
        operation="delete_group",
        op_kwargs={
            "GroupName": group_name,
            "AwsAccountId": aws_account_id,
            "Namespace": namespace,
        },
    )


async def describe(
    hub, ctx, group_name: str, aws_account_id: str, namespace: str
) -> Dict:
    r"""
    **Autogenerated function**

    Returns an Amazon QuickSight group's description and Amazon Resource Name (ARN).

    Args:
        group_name(str): The name of the group that you want to describe.
        aws_account_id(str): The ID for the Amazon Web Services account; that the group is in. Currently, you use the ID for the Amazon Web Services account; that contains your Amazon QuickSight account.
        namespace(str): The namespace. Currently, you should set this to default.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.quicksight.group.init.describe(
                ctx, group_name=value, aws_account_id=value, namespace=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.quicksight.group.init.describe group_name=value, aws_account_id=value, namespace=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="quicksight",
        operation="describe_group",
        op_kwargs={
            "GroupName": group_name,
            "AwsAccountId": aws_account_id,
            "Namespace": namespace,
        },
    )


async def list_all(
    hub,
    ctx,
    aws_account_id: str,
    namespace: str,
    next_token: str = None,
    max_results: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Lists all user groups in Amazon QuickSight.

    Args:
        aws_account_id(str): The ID for the Amazon Web Services account; that the group is in. Currently, you use the ID for the Amazon Web Services account; that contains your Amazon QuickSight account.
        next_token(str, optional): A pagination token that can be used in a subsequent request. Defaults to None.
        max_results(int, optional): The maximum number of results to return. Defaults to None.
        namespace(str): The namespace. Currently, you should set this to default.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.quicksight.group.init.list_all(
                ctx, aws_account_id=value, namespace=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.quicksight.group.init.list_all aws_account_id=value, namespace=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="quicksight",
        operation="list_groups",
        op_kwargs={
            "AwsAccountId": aws_account_id,
            "NextToken": next_token,
            "MaxResults": max_results,
            "Namespace": namespace,
        },
    )


async def update(
    hub,
    ctx,
    group_name: str,
    aws_account_id: str,
    namespace: str,
    description: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Changes a group description.

    Args:
        group_name(str): The name of the group that you want to update.
        description(str, optional): The description for the group that you want to update. Defaults to None.
        aws_account_id(str): The ID for the Amazon Web Services account; that the group is in. Currently, you use the ID for the Amazon Web Services account; that contains your Amazon QuickSight account.
        namespace(str): The namespace. Currently, you should set this to default.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.quicksight.group.init.update(
                ctx, group_name=value, aws_account_id=value, namespace=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.quicksight.group.init.update group_name=value, aws_account_id=value, namespace=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="quicksight",
        operation="update_group",
        op_kwargs={
            "GroupName": group_name,
            "Description": description,
            "AwsAccountId": aws_account_id,
            "Namespace": namespace,
        },
    )
