"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def describe_all(hub, ctx, aws_account_id: str, folder_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Describes the folder resolved permissions. Permissions consists of both folder direct permissions and the inherited permissions from the ancestor folders.

    Args:
        aws_account_id(str): The AWS account ID.
        folder_id(str): The folder ID.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.quicksight.folder.resolved_permission.describe_all(
                ctx, aws_account_id=value, folder_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.quicksight.folder.resolved_permission.describe_all aws_account_id=value, folder_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="quicksight",
        operation="describe_folder_resolved_permissions",
        op_kwargs={"AwsAccountId": aws_account_id, "FolderId": folder_id},
    )
