"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def describe_all(hub, ctx, aws_account_id: str, folder_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Describes permissions for a folder.

    Args:
        aws_account_id(str): The AWS Account ID.
        folder_id(str): The folder ID.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.quicksight.folder.permission.describe_all(
                ctx, aws_account_id=value, folder_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.quicksight.folder.permission.describe_all aws_account_id=value, folder_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="quicksight",
        operation="describe_folder_permissions",
        op_kwargs={"AwsAccountId": aws_account_id, "FolderId": folder_id},
    )


async def update_multiple(
    hub,
    ctx,
    aws_account_id: str,
    folder_id: str,
    grant_permissions: List = None,
    revoke_permissions: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates permissions of a folder.

    Args:
        aws_account_id(str): The AWS account ID.
        folder_id(str): The folder ID.
        grant_permissions(List, optional): The permissions that you want to grant on a resource. Defaults to None.
        revoke_permissions(List, optional): The permissions that you want to revoke from a resource. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.quicksight.folder.permission.update_multiple(
                ctx, aws_account_id=value, folder_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.quicksight.folder.permission.update_multiple aws_account_id=value, folder_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="quicksight",
        operation="update_folder_permissions",
        op_kwargs={
            "AwsAccountId": aws_account_id,
            "FolderId": folder_id,
            "GrantPermissions": grant_permissions,
            "RevokePermissions": revoke_permissions,
        },
    )
