"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(
    hub, ctx, aws_account_id: str, folder_id: str, member_id: str, member_type: str
) -> Dict:
    r"""
    **Autogenerated function**

    Adds an asset, such as a dashboard, analysis, or dataset into a folder.

    Args:
        aws_account_id(str): The AWS Account ID.
        folder_id(str): The folder ID.
        member_id(str): The ID of the asset (the dashboard, analysis, or dataset).
        member_type(str): The type of the member, including DASHBOARD, ANALYSIS, and DATASET.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.quicksight.folder.membership.create(
                ctx, aws_account_id=value, folder_id=value, member_id=value, member_type=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.quicksight.folder.membership.create aws_account_id=value, folder_id=value, member_id=value, member_type=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="quicksight",
        operation="create_folder_membership",
        op_kwargs={
            "AwsAccountId": aws_account_id,
            "FolderId": folder_id,
            "MemberId": member_id,
            "MemberType": member_type,
        },
    )


async def delete(
    hub, ctx, aws_account_id: str, folder_id: str, member_id: str, member_type: str
) -> Dict:
    r"""
    **Autogenerated function**

    Removes an asset, such as a dashboard, analysis, or dataset, from a folder.

    Args:
        aws_account_id(str): The AWS Account ID.
        folder_id(str): The Folder ID.
        member_id(str): The ID of the asset (the dashboard, analysis, or dataset) that you want to delete.
        member_type(str): The type of the member, including DASHBOARD, ANALYSIS, and DATASET .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.quicksight.folder.membership.delete(
                ctx, aws_account_id=value, folder_id=value, member_id=value, member_type=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.quicksight.folder.membership.delete aws_account_id=value, folder_id=value, member_id=value, member_type=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="quicksight",
        operation="delete_folder_membership",
        op_kwargs={
            "AwsAccountId": aws_account_id,
            "FolderId": folder_id,
            "MemberId": member_id,
            "MemberType": member_type,
        },
    )
