"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def list_all(
    hub,
    ctx,
    aws_account_id: str,
    folder_id: str,
    next_token: str = None,
    max_results: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    List all assets (DASHBOARD, ANALYSIS, and DATASET) in a folder.

    Args:
        aws_account_id(str): The AWS account ID.
        folder_id(str): The folder ID.
        next_token(str, optional): The token for the next set of results, or null if there are no more results. Defaults to None.
        max_results(int, optional): The maximum number of results to be returned per request. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.quicksight.folder.member.list_all(
                ctx, aws_account_id=value, folder_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.quicksight.folder.member.list_all aws_account_id=value, folder_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="quicksight",
        operation="list_folder_members",
        op_kwargs={
            "AwsAccountId": aws_account_id,
            "FolderId": folder_id,
            "NextToken": next_token,
            "MaxResults": max_results,
        },
    )
