"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    aws_account_id: str,
    folder_id: str,
    name: str = None,
    folder_type: str = None,
    parent_folder_arn: str = None,
    permissions: List = None,
    tags: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates an empty shared folder.

    Args:
        aws_account_id(str): The AWS Account ID.
        folder_id(str): The folder ID.
        name(str, optional): The name of the folder. Defaults to None.
        folder_type(str, optional): The type of folder. By default, folderType is SHARED. Defaults to None.
        parent_folder_arn(str, optional): The Amazon Resource Name (ARN) for the parent folder.  ParentFolderArn can be null. An empty parentFolderArn creates a root-level folder. Defaults to None.
        permissions(List, optional): A structure that describes the principals and the resource-level permissions of a folder. To specify no permissions, omit Permissions. Defaults to None.
        tags(List, optional): Tags for the folder. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.quicksight.folder.init.create(
                ctx, aws_account_id=value, folder_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.quicksight.folder.init.create aws_account_id=value, folder_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="quicksight",
        operation="create_folder",
        op_kwargs={
            "AwsAccountId": aws_account_id,
            "FolderId": folder_id,
            "Name": name,
            "FolderType": folder_type,
            "ParentFolderArn": parent_folder_arn,
            "Permissions": permissions,
            "Tags": tags,
        },
    )


async def delete(hub, ctx, aws_account_id: str, folder_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes an empty folder.

    Args:
        aws_account_id(str): The AWS Account ID for the folder.
        folder_id(str): The folder ID.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.quicksight.folder.init.delete(
                ctx, aws_account_id=value, folder_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.quicksight.folder.init.delete aws_account_id=value, folder_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="quicksight",
        operation="delete_folder",
        op_kwargs={"AwsAccountId": aws_account_id, "FolderId": folder_id},
    )


async def describe(hub, ctx, aws_account_id: str, folder_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Describes a folder.

    Args:
        aws_account_id(str): The AWS account ID.
        folder_id(str): The folder ID.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.quicksight.folder.init.describe(
                ctx, aws_account_id=value, folder_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.quicksight.folder.init.describe aws_account_id=value, folder_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="quicksight",
        operation="describe_folder",
        op_kwargs={"AwsAccountId": aws_account_id, "FolderId": folder_id},
    )


async def list_all(
    hub, ctx, aws_account_id: str, next_token: str = None, max_results: int = None
) -> Dict:
    r"""
    **Autogenerated function**

    Lists all folders in an account.

    Args:
        aws_account_id(str): The AWS account ID.
        next_token(str, optional): The token for the next set of results, or null if there are no more results. Defaults to None.
        max_results(int, optional): The maximum number of results to be returned per request. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.quicksight.folder.init.list_all(ctx, aws_account_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.quicksight.folder.init.list_all aws_account_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="quicksight",
        operation="list_folders",
        op_kwargs={
            "AwsAccountId": aws_account_id,
            "NextToken": next_token,
            "MaxResults": max_results,
        },
    )


async def search(
    hub,
    ctx,
    aws_account_id: str,
    filters: List,
    next_token: str = None,
    max_results: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Searches the subfolders in a folder.

    Args:
        aws_account_id(str): The AWS account ID.
        filters(List): The filters to apply to the search. Currently, you can search only by the parent folder ARN. For example, "Filters": [ { "Name": "PARENT_FOLDER_ARN", "Operator": "StringEquals", "Value": "arn:aws:quicksight:us-east-1:1:folder/folderId" } ].
        next_token(str, optional): The token for the next set of results, or null if there are no more results. Defaults to None.
        max_results(int, optional): The maximum number of results to be returned per request. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.quicksight.folder.init.search(
                ctx, aws_account_id=value, filters=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.quicksight.folder.init.search aws_account_id=value, filters=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="quicksight",
        operation="search_folders",
        op_kwargs={
            "AwsAccountId": aws_account_id,
            "Filters": filters,
            "NextToken": next_token,
            "MaxResults": max_results,
        },
    )


async def update(hub, ctx, aws_account_id: str, folder_id: str, name: str) -> Dict:
    r"""
    **Autogenerated function**

    Updates the name of a folder.

    Args:
        aws_account_id(str): The AWS account ID.
        folder_id(str): The folder ID.
        name(str): The name of the folder.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.quicksight.folder.init.update(
                ctx, aws_account_id=value, folder_id=value, name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.quicksight.folder.init.update aws_account_id=value, folder_id=value, name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="quicksight",
        operation="update_folder",
        op_kwargs={"AwsAccountId": aws_account_id, "FolderId": folder_id, "Name": name},
    )
