"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def generate(
    hub,
    ctx,
    aws_account_id: str,
    user_arn: str,
    experience_configuration: Dict,
    session_lifetime_in_minutes: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Generates an embed URL that you can use to embed an Amazon QuickSight experience in your website. This action can be used for any type of user registered in an Amazon QuickSight account. Before you use this action, make sure that you have configured the relevant Amazon QuickSight resource and permissions. The following rules apply to the generated URL:   It contains a temporary bearer token. It is valid for 5 minutes after it is generated. Once redeemed within this period, it cannot be re-used again.   The URL validity period should not be confused with the actual session lifetime that can be customized using the  SessionLifetimeInMinutes  parameter. The resulting user session is valid for 15 minutes (default) to 10 hours (maximum).   You are charged only when the URL is used or there is interaction with Amazon QuickSight.   For more information, see Embedded Analytics in the Amazon QuickSight User Guide. For more information about the high-level steps for embedding and for an interactive demo of the ways you can customize embedding, visit the Amazon QuickSight Developer Portal.

    Args:
        aws_account_id(str): The ID for the Amazon Web Services account that contains the dashboard that you're embedding.
        session_lifetime_in_minutes(int, optional): How many minutes the session is valid. The session lifetime must be in [15-600] minutes range. Defaults to None.
        user_arn(str): The Amazon Resource Name for the registered user.
        experience_configuration(Dict): The experience you are embedding. For registered users, you can embed Amazon QuickSight dashboards or the entire Amazon QuickSight console.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.quicksight.embed_url_for_.registered_user.generate(
                ctx, aws_account_id=value, user_arn=value, experience_configuration=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.quicksight.embed_url_for_.registered_user.generate aws_account_id=value, user_arn=value, experience_configuration=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="quicksight",
        operation="generate_embed_url_for_registered_user",
        op_kwargs={
            "AwsAccountId": aws_account_id,
            "SessionLifetimeInMinutes": session_lifetime_in_minutes,
            "UserArn": user_arn,
            "ExperienceConfiguration": experience_configuration,
        },
    )
