"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def generate(
    hub,
    ctx,
    aws_account_id: str,
    namespace: str,
    authorized_resource_arns: List,
    experience_configuration: Dict,
    session_lifetime_in_minutes: int = None,
    session_tags: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Generates an embed URL that you can use to embed an Amazon QuickSight dashboard in your website, without having to register any reader users. Before you use this action, make sure that you have configured the dashboards and permissions. The following rules apply to the generated URL:   It contains a temporary bearer token. It is valid for 5 minutes after it is generated. Once redeemed within this period, it cannot be re-used again.   The URL validity period should not be confused with the actual session lifetime that can be customized using the  SessionLifetimeInMinutes  parameter. The resulting user session is valid for 15 minutes (default) to 10 hours (maximum).   You are charged only when the URL is used or there is interaction with Amazon QuickSight.   For more information, see Embedded Analytics in the Amazon QuickSight User Guide. For more information about the high-level steps for embedding and for an interactive demo of the ways you can customize embedding, visit the Amazon QuickSight Developer Portal.

    Args:
        aws_account_id(str): The ID for the Amazon Web Services account that contains the dashboard that you're embedding.
        session_lifetime_in_minutes(int, optional): How many minutes the session is valid. The session lifetime must be in [15-600] minutes range. Defaults to None.
        namespace(str): The Amazon QuickSight namespace that the anonymous user virtually belongs to. If you are not using an Amazon QuickSight custom namespace, set this to default.
        session_tags(List, optional): The session tags used for row-level security. Before you use this parameter, make sure that you have configured the relevant datasets using the DataSet$RowLevelPermissionTagConfiguration parameter so that session tags can be used to provide row-level security. These are not the tags used for the Amazon Web Services resource tagging feature. For more information, see Using Row-Level Security (RLS) with Tags. Defaults to None.
        authorized_resource_arns(List): The Amazon Resource Names for the Amazon QuickSight resources that the user is authorized to access during the lifetime of the session. If you choose Dashboard embedding experience, pass the list of dashboard ARNs in the account that you want the user to be able to view.
        experience_configuration(Dict): The configuration of the experience you are embedding.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.quicksight.embed_url_for_.anonymous_user.generate(
                ctx,
                aws_account_id=value,
                namespace=value,
                authorized_resource_arns=value,
                experience_configuration=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.quicksight.embed_url_for_.anonymous_user.generate aws_account_id=value, namespace=value, authorized_resource_arns=value, experience_configuration=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="quicksight",
        operation="generate_embed_url_for_anonymous_user",
        op_kwargs={
            "AwsAccountId": aws_account_id,
            "SessionLifetimeInMinutes": session_lifetime_in_minutes,
            "Namespace": namespace,
            "SessionTags": session_tags,
            "AuthorizedResourceArns": authorized_resource_arns,
            "ExperienceConfiguration": experience_configuration,
        },
    )
