"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    aws_account_id: str,
    data_source_id: str,
    name: str,
    type_: str,
    data_source_parameters: Dict = None,
    credentials: Dict = None,
    permissions: List = None,
    vpc_connection_properties: Dict = None,
    ssl_properties: Dict = None,
    tags: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a data source.

    Args:
        aws_account_id(str): The Amazon Web Services account; ID.
        data_source_id(str): An ID for the data source. This ID is unique per Region; for each Amazon Web Services account;. .
        name(str): A display name for the data source.
        type_(str): The type of the data source. Currently, the supported types for this operation are: ATHENA, AURORA, AURORA_POSTGRESQL, AMAZON_ELASTICSEARCH, MARIADB, MYSQL, POSTGRESQL, PRESTO, REDSHIFT, S3, SNOWFLAKE, SPARK, SQLSERVER, TERADATA. Use ListDataSources to return a list of all data sources.  AMAZON_ELASTICSEARCH is for Amazon managed Elasticsearch Service.
        data_source_parameters(Dict, optional): The parameters that QuickSight uses to connect to your underlying source. Defaults to None.
        credentials(Dict, optional): The credentials QuickSight that uses to connect to your underlying source. Currently, only credentials based on user name and password are supported. Defaults to None.
        permissions(List, optional): A list of resource permissions on the data source. Defaults to None.
        vpc_connection_properties(Dict, optional): Use this parameter only when you want QuickSight to use a VPC connection when connecting to your underlying source. Defaults to None.
        ssl_properties(Dict, optional): Secure Socket Layer (SSL) properties that apply when QuickSight connects to your underlying source. Defaults to None.
        tags(List, optional): Contains a map of the key-value pairs for the resource tag or tags assigned to the data source. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.quicksight.data.source.init.create(
                ctx, aws_account_id=value, data_source_id=value, name=value, type_=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.quicksight.data.source.init.create aws_account_id=value, data_source_id=value, name=value, type_=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="quicksight",
        operation="create_data_source",
        op_kwargs={
            "AwsAccountId": aws_account_id,
            "DataSourceId": data_source_id,
            "Name": name,
            "Type": type_,
            "DataSourceParameters": data_source_parameters,
            "Credentials": credentials,
            "Permissions": permissions,
            "VpcConnectionProperties": vpc_connection_properties,
            "SslProperties": ssl_properties,
            "Tags": tags,
        },
    )


async def delete(hub, ctx, aws_account_id: str, data_source_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes the data source permanently. This operation breaks all the datasets that reference the deleted data source.

    Args:
        aws_account_id(str): The Amazon Web Services account; ID.
        data_source_id(str): The ID of the data source. This ID is unique per Region; for each Amazon Web Services account;.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.quicksight.data.source.init.delete(
                ctx, aws_account_id=value, data_source_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.quicksight.data.source.init.delete aws_account_id=value, data_source_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="quicksight",
        operation="delete_data_source",
        op_kwargs={"AwsAccountId": aws_account_id, "DataSourceId": data_source_id},
    )


async def describe(hub, ctx, aws_account_id: str, data_source_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Describes a data source.

    Args:
        aws_account_id(str): The Amazon Web Services account; ID.
        data_source_id(str): The ID of the data source. This ID is unique per Region; for each Amazon Web Services account;.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.quicksight.data.source.init.describe(
                ctx, aws_account_id=value, data_source_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.quicksight.data.source.init.describe aws_account_id=value, data_source_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="quicksight",
        operation="describe_data_source",
        op_kwargs={"AwsAccountId": aws_account_id, "DataSourceId": data_source_id},
    )


async def list_all(
    hub, ctx, aws_account_id: str, next_token: str = None, max_results: int = None
) -> Dict:
    r"""
    **Autogenerated function**

    Lists data sources in current Region; that belong to this Amazon Web Services account;.

    Args:
        aws_account_id(str): The Amazon Web Services account; ID.
        next_token(str, optional): The token for the next set of results, or null if there are no more results. Defaults to None.
        max_results(int, optional): The maximum number of results to be returned per request. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.quicksight.data.source.init.list_all(ctx, aws_account_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.quicksight.data.source.init.list_all aws_account_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="quicksight",
        operation="list_data_sources",
        op_kwargs={
            "AwsAccountId": aws_account_id,
            "NextToken": next_token,
            "MaxResults": max_results,
        },
    )


async def update(
    hub,
    ctx,
    aws_account_id: str,
    data_source_id: str,
    name: str,
    data_source_parameters: Dict = None,
    credentials: Dict = None,
    vpc_connection_properties: Dict = None,
    ssl_properties: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates a data source.

    Args:
        aws_account_id(str): The Amazon Web Services account; ID.
        data_source_id(str): The ID of the data source. This ID is unique per Region; for each Amazon Web Services account;. .
        name(str): A display name for the data source.
        data_source_parameters(Dict, optional): The parameters that QuickSight uses to connect to your underlying source. Defaults to None.
        credentials(Dict, optional): The credentials that QuickSight that uses to connect to your underlying source. Currently, only credentials based on user name and password are supported. Defaults to None.
        vpc_connection_properties(Dict, optional): Use this parameter only when you want QuickSight to use a VPC connection when connecting to your underlying source. Defaults to None.
        ssl_properties(Dict, optional): Secure Socket Layer (SSL) properties that apply when QuickSight connects to your underlying source. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.quicksight.data.source.init.update(
                ctx, aws_account_id=value, data_source_id=value, name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.quicksight.data.source.init.update aws_account_id=value, data_source_id=value, name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="quicksight",
        operation="update_data_source",
        op_kwargs={
            "AwsAccountId": aws_account_id,
            "DataSourceId": data_source_id,
            "Name": name,
            "DataSourceParameters": data_source_parameters,
            "Credentials": credentials,
            "VpcConnectionProperties": vpc_connection_properties,
            "SslProperties": ssl_properties,
        },
    )
