"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def describe_all(hub, ctx, aws_account_id: str, data_set_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Describes the permissions on a dataset. The permissions resource is arn:aws:quicksight:region:aws-account-id:dataset/data-set-id.

    Args:
        aws_account_id(str): The Amazon Web Services account; ID.
        data_set_id(str): The ID for the dataset that you want to create. This ID is unique per Region; for each Amazon Web Services account;.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.quicksight.data.set_.permission.describe_all(
                ctx, aws_account_id=value, data_set_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.quicksight.data.set_.permission.describe_all aws_account_id=value, data_set_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="quicksight",
        operation="describe_data_set_permissions",
        op_kwargs={"AwsAccountId": aws_account_id, "DataSetId": data_set_id},
    )


async def update_multiple(
    hub,
    ctx,
    aws_account_id: str,
    data_set_id: str,
    grant_permissions: List = None,
    revoke_permissions: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates the permissions on a dataset. The permissions resource is arn:aws:quicksight:region:aws-account-id:dataset/data-set-id.

    Args:
        aws_account_id(str): The Amazon Web Services account; ID.
        data_set_id(str): The ID for the dataset whose permissions you want to update. This ID is unique per Region; for each Amazon Web Services account;.
        grant_permissions(List, optional): The resource permissions that you want to grant to the dataset. Defaults to None.
        revoke_permissions(List, optional): The resource permissions that you want to revoke from the dataset. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.quicksight.data.set_.permission.update_multiple(
                ctx, aws_account_id=value, data_set_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.quicksight.data.set_.permission.update_multiple aws_account_id=value, data_set_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="quicksight",
        operation="update_data_set_permissions",
        op_kwargs={
            "AwsAccountId": aws_account_id,
            "DataSetId": data_set_id,
            "GrantPermissions": grant_permissions,
            "RevokePermissions": revoke_permissions,
        },
    )
