"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    aws_account_id: str,
    data_set_id: str,
    name: str,
    physical_table_map: Dict,
    import_mode: str,
    logical_table_map: Dict = None,
    column_groups: List = None,
    field_folders: Dict = None,
    permissions: List = None,
    row_level_permission_data_set: Dict = None,
    row_level_permission_tag_configuration: Dict = None,
    column_level_permission_rules: List = None,
    tags: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a dataset.

    Args:
        aws_account_id(str): The Amazon Web Services account; ID.
        data_set_id(str): An ID for the dataset that you want to create. This ID is unique per Region; for each Amazon Web Services account;.
        name(str): The display name for the dataset.
        physical_table_map(Dict): Declares the physical tables that are available in the underlying data sources.
        logical_table_map(Dict, optional): Configures the combination and transformation of the data from the physical tables. Defaults to None.
        import_mode(str): Indicates whether you want to import the data into SPICE.
        column_groups(List, optional): Groupings of columns that work together in certain QuickSight features. Currently, only geospatial hierarchy is supported. Defaults to None.
        field_folders(Dict, optional): The folder that contains fields and nested subfolders for your dataset. Defaults to None.
        permissions(List, optional): A list of resource permissions on the dataset. Defaults to None.
        row_level_permission_data_set(Dict, optional): The row-level security configuration for the data that you want to create. Defaults to None.
        row_level_permission_tag_configuration(Dict, optional): The configuration of tags on a dataset to set row-level security. Row-level security tags are currently supported for anonymous embedding only. Defaults to None.
        column_level_permission_rules(List, optional): A set of one or more definitions of a  ColumnLevelPermissionRule . Defaults to None.
        tags(List, optional): Contains a map of the key-value pairs for the resource tag or tags assigned to the dataset. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.quicksight.data.set_.init.create(
                ctx,
                aws_account_id=value,
                data_set_id=value,
                name=value,
                physical_table_map=value,
                import_mode=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.quicksight.data.set_.init.create aws_account_id=value, data_set_id=value, name=value, physical_table_map=value, import_mode=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="quicksight",
        operation="create_data_set",
        op_kwargs={
            "AwsAccountId": aws_account_id,
            "DataSetId": data_set_id,
            "Name": name,
            "PhysicalTableMap": physical_table_map,
            "LogicalTableMap": logical_table_map,
            "ImportMode": import_mode,
            "ColumnGroups": column_groups,
            "FieldFolders": field_folders,
            "Permissions": permissions,
            "RowLevelPermissionDataSet": row_level_permission_data_set,
            "RowLevelPermissionTagConfiguration": row_level_permission_tag_configuration,
            "ColumnLevelPermissionRules": column_level_permission_rules,
            "Tags": tags,
        },
    )


async def delete(hub, ctx, aws_account_id: str, data_set_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes a dataset.

    Args:
        aws_account_id(str): The Amazon Web Services account; ID.
        data_set_id(str): The ID for the dataset that you want to create. This ID is unique per Region; for each Amazon Web Services account;.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.quicksight.data.set_.init.delete(
                ctx, aws_account_id=value, data_set_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.quicksight.data.set_.init.delete aws_account_id=value, data_set_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="quicksight",
        operation="delete_data_set",
        op_kwargs={"AwsAccountId": aws_account_id, "DataSetId": data_set_id},
    )


async def describe(hub, ctx, aws_account_id: str, data_set_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Describes a dataset.

    Args:
        aws_account_id(str): The Amazon Web Services account; ID.
        data_set_id(str): The ID for the dataset that you want to create. This ID is unique per Region; for each Amazon Web Services account;.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.quicksight.data.set_.init.describe(
                ctx, aws_account_id=value, data_set_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.quicksight.data.set_.init.describe aws_account_id=value, data_set_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="quicksight",
        operation="describe_data_set",
        op_kwargs={"AwsAccountId": aws_account_id, "DataSetId": data_set_id},
    )


async def list_all(
    hub, ctx, aws_account_id: str, next_token: str = None, max_results: int = None
) -> Dict:
    r"""
    **Autogenerated function**

    Lists all of the datasets belonging to the current Amazon Web Services account; in an Region;. The permissions resource is arn:aws:quicksight:region:aws-account-id:dataset/*.

    Args:
        aws_account_id(str): The Amazon Web Services account; ID.
        next_token(str, optional): The token for the next set of results, or null if there are no more results. Defaults to None.
        max_results(int, optional): The maximum number of results to be returned per request. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.quicksight.data.set_.init.list_all(ctx, aws_account_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.quicksight.data.set_.init.list_all aws_account_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="quicksight",
        operation="list_data_sets",
        op_kwargs={
            "AwsAccountId": aws_account_id,
            "NextToken": next_token,
            "MaxResults": max_results,
        },
    )


async def update(
    hub,
    ctx,
    aws_account_id: str,
    data_set_id: str,
    name: str,
    physical_table_map: Dict,
    import_mode: str,
    logical_table_map: Dict = None,
    column_groups: List = None,
    field_folders: Dict = None,
    row_level_permission_data_set: Dict = None,
    row_level_permission_tag_configuration: Dict = None,
    column_level_permission_rules: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates a dataset.

    Args:
        aws_account_id(str): The Amazon Web Services account; ID.
        data_set_id(str): The ID for the dataset that you want to update. This ID is unique per Region; for each Amazon Web Services account;.
        name(str): The display name for the dataset.
        physical_table_map(Dict): Declares the physical tables that are available in the underlying data sources.
        logical_table_map(Dict, optional): Configures the combination and transformation of the data from the physical tables. Defaults to None.
        import_mode(str): Indicates whether you want to import the data into SPICE.
        column_groups(List, optional): Groupings of columns that work together in certain QuickSight features. Currently, only geospatial hierarchy is supported. Defaults to None.
        field_folders(Dict, optional): The folder that contains fields and nested subfolders for your dataset. Defaults to None.
        row_level_permission_data_set(Dict, optional): The row-level security configuration for the data you want to create. Defaults to None.
        row_level_permission_tag_configuration(Dict, optional): The configuration of tags on a dataset to set row-level security. Row-level security tags are currently supported for anonymous embedding only. Defaults to None.
        column_level_permission_rules(List, optional): A set of one or more definitions of a  ColumnLevelPermissionRule . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.quicksight.data.set_.init.update(
                ctx,
                aws_account_id=value,
                data_set_id=value,
                name=value,
                physical_table_map=value,
                import_mode=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.quicksight.data.set_.init.update aws_account_id=value, data_set_id=value, name=value, physical_table_map=value, import_mode=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="quicksight",
        operation="update_data_set",
        op_kwargs={
            "AwsAccountId": aws_account_id,
            "DataSetId": data_set_id,
            "Name": name,
            "PhysicalTableMap": physical_table_map,
            "LogicalTableMap": logical_table_map,
            "ImportMode": import_mode,
            "ColumnGroups": column_groups,
            "FieldFolders": field_folders,
            "RowLevelPermissionDataSet": row_level_permission_data_set,
            "RowLevelPermissionTagConfiguration": row_level_permission_tag_configuration,
            "ColumnLevelPermissionRules": column_level_permission_rules,
        },
    )
