"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def list_all(
    hub,
    ctx,
    aws_account_id: str,
    dashboard_id: str,
    next_token: str = None,
    max_results: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Lists all the versions of the dashboards in the QuickSight subscription.

    Args:
        aws_account_id(str): The ID of the Amazon Web Services account; that contains the dashboard that you're listing versions for.
        dashboard_id(str): The ID for the dashboard.
        next_token(str, optional): The token for the next set of results, or null if there are no more results. Defaults to None.
        max_results(int, optional): The maximum number of results to be returned per request. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.quicksight.dashboard.version.list_all(
                ctx, aws_account_id=value, dashboard_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.quicksight.dashboard.version.list_all aws_account_id=value, dashboard_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="quicksight",
        operation="list_dashboard_versions",
        op_kwargs={
            "AwsAccountId": aws_account_id,
            "DashboardId": dashboard_id,
            "NextToken": next_token,
            "MaxResults": max_results,
        },
    )
