"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def update(
    hub, ctx, aws_account_id: str, dashboard_id: str, version_number: int
) -> Dict:
    r"""
    **Autogenerated function**

    Updates the published version of a dashboard.

    Args:
        aws_account_id(str): The ID of the Amazon Web Services account; that contains the dashboard that you're updating.
        dashboard_id(str): The ID for the dashboard.
        version_number(int): The version number of the dashboard.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.quicksight.dashboard.published_version.update(
                ctx, aws_account_id=value, dashboard_id=value, version_number=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.quicksight.dashboard.published_version.update aws_account_id=value, dashboard_id=value, version_number=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="quicksight",
        operation="update_dashboard_published_version",
        op_kwargs={
            "AwsAccountId": aws_account_id,
            "DashboardId": dashboard_id,
            "VersionNumber": version_number,
        },
    )
