"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def describe_all(hub, ctx, aws_account_id: str, dashboard_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Describes read and write permissions for a dashboard.

    Args:
        aws_account_id(str): The ID of the Amazon Web Services account; that contains the dashboard that you're describing permissions for.
        dashboard_id(str): The ID for the dashboard, also added to the IAM policy.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.quicksight.dashboard.permission.describe_all(
                ctx, aws_account_id=value, dashboard_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.quicksight.dashboard.permission.describe_all aws_account_id=value, dashboard_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="quicksight",
        operation="describe_dashboard_permissions",
        op_kwargs={"AwsAccountId": aws_account_id, "DashboardId": dashboard_id},
    )


async def update_multiple(
    hub,
    ctx,
    aws_account_id: str,
    dashboard_id: str,
    grant_permissions: List = None,
    revoke_permissions: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates read and write permissions on a dashboard.

    Args:
        aws_account_id(str): The ID of the Amazon Web Services account; that contains the dashboard whose permissions you're updating.
        dashboard_id(str): The ID for the dashboard.
        grant_permissions(List, optional): The permissions that you want to grant on this resource. Defaults to None.
        revoke_permissions(List, optional): The permissions that you want to revoke from this resource. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.quicksight.dashboard.permission.update_multiple(
                ctx, aws_account_id=value, dashboard_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.quicksight.dashboard.permission.update_multiple aws_account_id=value, dashboard_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="quicksight",
        operation="update_dashboard_permissions",
        op_kwargs={
            "AwsAccountId": aws_account_id,
            "DashboardId": dashboard_id,
            "GrantPermissions": grant_permissions,
            "RevokePermissions": revoke_permissions,
        },
    )
