"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    aws_account_id: str,
    dashboard_id: str,
    name: str,
    source_entity: Dict,
    parameters: Dict = None,
    permissions: List = None,
    tags: List = None,
    version_description: str = None,
    dashboard_publish_options: Dict = None,
    theme_arn: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a dashboard from a template. To first create a template, see the  CreateTemplate  API operation. A dashboard is an entity in QuickSight that identifies QuickSight reports, created from analyses. You can share QuickSight dashboards. With the right permissions, you can create scheduled email reports from them. If you have the correct permissions, you can create a dashboard from a template that exists in a different Amazon Web Services account;.

    Args:
        aws_account_id(str): The ID of the Amazon Web Services account; where you want to create the dashboard.
        dashboard_id(str): The ID for the dashboard, also added to the IAM policy.
        name(str): The display name of the dashboard.
        parameters(Dict, optional): The parameters for the creation of the dashboard, which you want to use to override the default settings. A dashboard can have any type of parameters, and some parameters might accept multiple values. . Defaults to None.
        permissions(List, optional): A structure that contains the permissions of the dashboard. You can use this structure for granting permissions by providing a list of IAM action information for each principal ARN.  To specify no permissions, omit the permissions list. Defaults to None.
        source_entity(Dict): The entity that you are using as a source when you create the dashboard. In SourceEntity, you specify the type of object you're using as source. You can only create a dashboard from a template, so you use a SourceTemplate entity. If you need to create a dashboard from an analysis, first convert the analysis to a template by using the CreateTemplate API operation. For SourceTemplate, specify the Amazon Resource Name (ARN) of the source template. The SourceTemplateARN can contain any Amazon Web Services account; and any QuickSight-supported Region;.  Use the DataSetReferences entity within SourceTemplate to list the replacement datasets for the placeholders listed in the original. The schema in each dataset must match its placeholder. .
        tags(List, optional): Contains a map of the key-value pairs for the resource tag or tags assigned to the dashboard. Defaults to None.
        version_description(str, optional): A description for the first version of the dashboard being created. Defaults to None.
        dashboard_publish_options(Dict, optional): Options for publishing the dashboard when you create it:    AvailabilityStatus for AdHocFilteringOption - This status can be either ENABLED or DISABLED. When this is set to DISABLED, QuickSight disables the left filter pane on the published dashboard, which can be used for ad hoc (one-time) filtering. This option is ENABLED by default.     AvailabilityStatus for ExportToCSVOption - This status can be either ENABLED or DISABLED. The visual option to export data to .CSV format isn't enabled when this is set to DISABLED. This option is ENABLED by default.     VisibilityState for SheetControlsOption - This visibility state can be either COLLAPSED or EXPANDED. This option is COLLAPSED by default.   . Defaults to None.
        theme_arn(str, optional): The Amazon Resource Name (ARN) of the theme that is being used for this dashboard. If you add a value for this field, it overrides the value that is used in the source entity. The theme ARN must exist in the same Amazon Web Services account; where you create the dashboard. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.quicksight.dashboard.init.create(
                ctx, aws_account_id=value, dashboard_id=value, name=value, source_entity=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.quicksight.dashboard.init.create aws_account_id=value, dashboard_id=value, name=value, source_entity=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="quicksight",
        operation="create_dashboard",
        op_kwargs={
            "AwsAccountId": aws_account_id,
            "DashboardId": dashboard_id,
            "Name": name,
            "Parameters": parameters,
            "Permissions": permissions,
            "SourceEntity": source_entity,
            "Tags": tags,
            "VersionDescription": version_description,
            "DashboardPublishOptions": dashboard_publish_options,
            "ThemeArn": theme_arn,
        },
    )


async def delete(
    hub, ctx, aws_account_id: str, dashboard_id: str, version_number: int = None
) -> Dict:
    r"""
    **Autogenerated function**

    Deletes a dashboard.

    Args:
        aws_account_id(str): The ID of the Amazon Web Services account; that contains the dashboard that you're deleting.
        dashboard_id(str): The ID for the dashboard.
        version_number(int, optional): The version number of the dashboard. If the version number property is provided, only the specified version of the dashboard is deleted. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.quicksight.dashboard.init.delete(
                ctx, aws_account_id=value, dashboard_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.quicksight.dashboard.init.delete aws_account_id=value, dashboard_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="quicksight",
        operation="delete_dashboard",
        op_kwargs={
            "AwsAccountId": aws_account_id,
            "DashboardId": dashboard_id,
            "VersionNumber": version_number,
        },
    )


async def describe(
    hub,
    ctx,
    aws_account_id: str,
    dashboard_id: str,
    version_number: int = None,
    alias_name: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Provides a summary for a dashboard.

    Args:
        aws_account_id(str): The ID of the Amazon Web Services account; that contains the dashboard that you're describing.
        dashboard_id(str): The ID for the dashboard.
        version_number(int, optional): The version number for the dashboard. If a version number isn't passed, the latest published dashboard version is described. . Defaults to None.
        alias_name(str, optional): The alias name. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.quicksight.dashboard.init.describe(
                ctx, aws_account_id=value, dashboard_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.quicksight.dashboard.init.describe aws_account_id=value, dashboard_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="quicksight",
        operation="describe_dashboard",
        op_kwargs={
            "AwsAccountId": aws_account_id,
            "DashboardId": dashboard_id,
            "VersionNumber": version_number,
            "AliasName": alias_name,
        },
    )


async def list_all(
    hub, ctx, aws_account_id: str, next_token: str = None, max_results: int = None
) -> Dict:
    r"""
    **Autogenerated function**

    Lists dashboards in an Amazon Web Services account;.

    Args:
        aws_account_id(str): The ID of the Amazon Web Services account; that contains the dashboards that you're listing.
        next_token(str, optional): The token for the next set of results, or null if there are no more results. Defaults to None.
        max_results(int, optional): The maximum number of results to be returned per request. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.quicksight.dashboard.init.list_all(ctx, aws_account_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.quicksight.dashboard.init.list_all aws_account_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="quicksight",
        operation="list_dashboards",
        op_kwargs={
            "AwsAccountId": aws_account_id,
            "NextToken": next_token,
            "MaxResults": max_results,
        },
    )


async def search(
    hub,
    ctx,
    aws_account_id: str,
    filters: List,
    next_token: str = None,
    max_results: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Searches for dashboards that belong to a user.   This operation is eventually consistent. The results are best effort and may not reflect very recent updates and changes.

    Args:
        aws_account_id(str): The ID of the Amazon Web Services account; that contains the user whose dashboards you're searching for. .
        filters(List): The filters to apply to the search. Currently, you can search only by user name, for example, "Filters": [ { "Name": "QUICKSIGHT_USER", "Operator": "StringEquals", "Value": "arn:aws:quicksight:us-east-1:1:user/default/UserName1" } ] .
        next_token(str, optional): The token for the next set of results, or null if there are no more results. Defaults to None.
        max_results(int, optional): The maximum number of results to be returned per request. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.quicksight.dashboard.init.search(
                ctx, aws_account_id=value, filters=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.quicksight.dashboard.init.search aws_account_id=value, filters=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="quicksight",
        operation="search_dashboards",
        op_kwargs={
            "AwsAccountId": aws_account_id,
            "Filters": filters,
            "NextToken": next_token,
            "MaxResults": max_results,
        },
    )


async def update(
    hub,
    ctx,
    aws_account_id: str,
    dashboard_id: str,
    name: str,
    source_entity: Dict,
    parameters: Dict = None,
    version_description: str = None,
    dashboard_publish_options: Dict = None,
    theme_arn: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates a dashboard in an Amazon Web Services account;.  Updating a Dashboard creates a new dashboard version but does not immediately publish the new version. You can update the published version of a dashboard by using the UpdateDashboardPublishedVersion API operation.

    Args:
        aws_account_id(str): The ID of the Amazon Web Services account; that contains the dashboard that you're updating.
        dashboard_id(str): The ID for the dashboard.
        name(str): The display name of the dashboard.
        source_entity(Dict): The entity that you are using as a source when you update the dashboard. In SourceEntity, you specify the type of object you're using as source. You can only update a dashboard from a template, so you use a SourceTemplate entity. If you need to update a dashboard from an analysis, first convert the analysis to a template by using the CreateTemplate API operation. For SourceTemplate, specify the Amazon Resource Name (ARN) of the source template. The SourceTemplate ARN can contain any Amazon Web Services account; and any QuickSight-supported Region;.  Use the DataSetReferences entity within SourceTemplate to list the replacement datasets for the placeholders listed in the original. The schema in each dataset must match its placeholder. .
        parameters(Dict, optional): A structure that contains the parameters of the dashboard. These are parameter overrides for a dashboard. A dashboard can have any type of parameters, and some parameters might accept multiple values. Defaults to None.
        version_description(str, optional): A description for the first version of the dashboard being created. Defaults to None.
        dashboard_publish_options(Dict, optional): Options for publishing the dashboard when you create it:    AvailabilityStatus for AdHocFilteringOption - This status can be either ENABLED or DISABLED. When this is set to DISABLED, QuickSight disables the left filter pane on the published dashboard, which can be used for ad hoc (one-time) filtering. This option is ENABLED by default.     AvailabilityStatus for ExportToCSVOption - This status can be either ENABLED or DISABLED. The visual option to export data to .CSV format isn't enabled when this is set to DISABLED. This option is ENABLED by default.     VisibilityState for SheetControlsOption - This visibility state can be either COLLAPSED or EXPANDED. This option is COLLAPSED by default.   . Defaults to None.
        theme_arn(str, optional): The Amazon Resource Name (ARN) of the theme that is being used for this dashboard. If you add a value for this field, it overrides the value that was originally associated with the entity. The theme ARN must exist in the same Amazon Web Services account; where you create the dashboard. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.quicksight.dashboard.init.update(
                ctx, aws_account_id=value, dashboard_id=value, name=value, source_entity=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.quicksight.dashboard.init.update aws_account_id=value, dashboard_id=value, name=value, source_entity=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="quicksight",
        operation="update_dashboard",
        op_kwargs={
            "AwsAccountId": aws_account_id,
            "DashboardId": dashboard_id,
            "Name": name,
            "SourceEntity": source_entity,
            "Parameters": parameters,
            "VersionDescription": version_description,
            "DashboardPublishOptions": dashboard_publish_options,
            "ThemeArn": theme_arn,
        },
    )
