"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def get(
    hub,
    ctx,
    aws_account_id: str,
    dashboard_id: str,
    identity_type: str,
    session_lifetime_in_minutes: int = None,
    undo_redo_disabled: bool = None,
    reset_disabled: bool = None,
    state_persistence_enabled: bool = None,
    user_arn: str = None,
    namespace: str = None,
    additional_dashboard_ids: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Generates a session URL and authorization code that you can use to embed an Amazon QuickSight read-only dashboard in your web server code. Before you use this command, make sure that you have configured the dashboards and permissions.  Currently, you can use GetDashboardEmbedURL only from the server, not from the user's browser. The following rules apply to the combination of URL and authorization code:   They must be used together.   They can be used one time only.   They are valid for 5 minutes after you run this command.   The resulting user session is valid for 10 hours.   For more information, see Embedded Analytics in the Amazon QuickSight User Guide. For more information about the high-level steps for embedding and for an interactive demo of the ways you can customize embedding, visit the Amazon QuickSight Developer Portal.

    Args:
        aws_account_id(str): The ID for the Amazon Web Services account; that contains the dashboard that you're embedding.
        dashboard_id(str): The ID for the dashboard, also added to the Identity and Access Management (IAM) policy.
        identity_type(str): The authentication method that the user uses to sign in.
        session_lifetime_in_minutes(int, optional): How many minutes the session is valid. The session lifetime must be 15-600 minutes. Defaults to None.
        undo_redo_disabled(bool, optional): Remove the undo/redo button on the embedded dashboard. The default is FALSE, which enables the undo/redo button. Defaults to None.
        reset_disabled(bool, optional): Remove the reset button on the embedded dashboard. The default is FALSE, which enables the reset button. Defaults to None.
        state_persistence_enabled(bool, optional): Adds persistence of state for the user session in an embedded dashboard. Persistence applies to the sheet and the parameter settings. These are control settings that the dashboard subscriber (QuickSight reader) chooses while viewing the dashboard. If this is set to TRUE, the settings are the same when the subscriber reopens the same dashboard URL. The state is stored in QuickSight, not in a browser cookie. If this is set to FALSE, the state of the user session is not persisted. The default is FALSE. Defaults to None.
        user_arn(str, optional): The Amazon QuickSight user's Amazon Resource Name (ARN), for use with QUICKSIGHT identity type. You can use this for any Amazon QuickSight users in your account (readers, authors, or admins) authenticated as one of the following:   Active Directory (AD) users or group members   Invited nonfederated users   IAM users and IAM role-based sessions authenticated through Federated Single Sign-On using SAML, OpenID Connect, or IAM federation.   Omit this parameter for users in the third group – IAM users and IAM role-based sessions. Defaults to None.
        namespace(str, optional): The Amazon QuickSight namespace that the user virtually belongs to. If you are not using an Amazon QuickSight custom namespace, set this to default. Defaults to None.
        additional_dashboard_ids(List, optional): A list of one or more dashboard IDs that you want to add to a session that includes anonymous users. The IdentityType parameter must be set to ANONYMOUS for this to work, because other identity types authenticate as QuickSight or IAM users. For example, if you set "--dashboard-id dash_id1 --dashboard-id dash_id2 dash_id3 identity-type ANONYMOUS", the session can access all three dashboards. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.quicksight.dashboard.embed_url.get(
                ctx, aws_account_id=value, dashboard_id=value, identity_type=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.quicksight.dashboard.embed_url.get aws_account_id=value, dashboard_id=value, identity_type=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="quicksight",
        operation="get_dashboard_embed_url",
        op_kwargs={
            "AwsAccountId": aws_account_id,
            "DashboardId": dashboard_id,
            "IdentityType": identity_type,
            "SessionLifetimeInMinutes": session_lifetime_in_minutes,
            "UndoRedoDisabled": undo_redo_disabled,
            "ResetDisabled": reset_disabled,
            "StatePersistenceEnabled": state_persistence_enabled,
            "UserArn": user_arn,
            "Namespace": namespace,
            "AdditionalDashboardIds": additional_dashboard_ids,
        },
    )
