"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def describe_all(hub, ctx, aws_account_id: str, analysis_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Provides the read and write permissions for an analysis.

    Args:
        aws_account_id(str): The ID of the Amazon Web Services account; that contains the analysis whose permissions you're describing. You must be using the Amazon Web Services account; that the analysis is in.
        analysis_id(str): The ID of the analysis whose permissions you're describing. The ID is part of the analysis URL.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.quicksight.analysis.permission.describe_all(
                ctx, aws_account_id=value, analysis_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.quicksight.analysis.permission.describe_all aws_account_id=value, analysis_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="quicksight",
        operation="describe_analysis_permissions",
        op_kwargs={"AwsAccountId": aws_account_id, "AnalysisId": analysis_id},
    )


async def update_multiple(
    hub,
    ctx,
    aws_account_id: str,
    analysis_id: str,
    grant_permissions: List = None,
    revoke_permissions: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates the read and write permissions for an analysis.

    Args:
        aws_account_id(str): The ID of the Amazon Web Services account; that contains the analysis whose permissions you're updating. You must be using the Amazon Web Services account; that the analysis is in.
        analysis_id(str): The ID of the analysis whose permissions you're updating. The ID is part of the analysis URL.
        grant_permissions(List, optional): A structure that describes the permissions to add and the principal to add them to. Defaults to None.
        revoke_permissions(List, optional): A structure that describes the permissions to remove and the principal to remove them from. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.quicksight.analysis.permission.update_multiple(
                ctx, aws_account_id=value, analysis_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.quicksight.analysis.permission.update_multiple aws_account_id=value, analysis_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="quicksight",
        operation="update_analysis_permissions",
        op_kwargs={
            "AwsAccountId": aws_account_id,
            "AnalysisId": analysis_id,
            "GrantPermissions": grant_permissions,
            "RevokePermissions": revoke_permissions,
        },
    )
