"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    aws_account_id: str,
    analysis_id: str,
    name: str,
    source_entity: Dict,
    parameters: Dict = None,
    permissions: List = None,
    theme_arn: str = None,
    tags: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates an analysis in Amazon QuickSight.

    Args:
        aws_account_id(str): The ID of the Amazon Web Services account; where you are creating an analysis.
        analysis_id(str): The ID for the analysis that you're creating. This ID displays in the URL of the analysis.
        name(str): A descriptive name for the analysis that you're creating. This name displays for the analysis in the QuickSight console. .
        parameters(Dict, optional): The parameter names and override values that you want to use. An analysis can have any parameter type, and some parameters might accept multiple values. . Defaults to None.
        permissions(List, optional): A structure that describes the principals and the resource-level permissions on an analysis. You can use the Permissions structure to grant permissions by providing a list of Identity and Access Management (IAM) action information for each principal listed by Amazon Resource Name (ARN).  To specify no permissions, omit Permissions. Defaults to None.
        source_entity(Dict): A source entity to use for the analysis that you're creating. This metadata structure contains details that describe a source template and one or more datasets.
        theme_arn(str, optional): The ARN for the theme to apply to the analysis that you're creating. To see the theme in the QuickSight console, make sure that you have access to it. Defaults to None.
        tags(List, optional): Contains a map of the key-value pairs for the resource tag or tags assigned to the analysis. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.quicksight.analysis.init.create(
                ctx, aws_account_id=value, analysis_id=value, name=value, source_entity=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.quicksight.analysis.init.create aws_account_id=value, analysis_id=value, name=value, source_entity=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="quicksight",
        operation="create_analysis",
        op_kwargs={
            "AwsAccountId": aws_account_id,
            "AnalysisId": analysis_id,
            "Name": name,
            "Parameters": parameters,
            "Permissions": permissions,
            "SourceEntity": source_entity,
            "ThemeArn": theme_arn,
            "Tags": tags,
        },
    )


async def delete(
    hub,
    ctx,
    aws_account_id: str,
    analysis_id: str,
    recovery_window_in_days: int = None,
    force_delete_without_recovery: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Deletes an analysis from Amazon QuickSight. You can optionally include a recovery window during which you can restore the analysis. If you don't specify a recovery window value, the operation defaults to 30 days. QuickSight attaches a DeletionTime stamp to the response that specifies the end of the recovery window. At the end of the recovery window, QuickSight deletes the analysis permanently. At any time before recovery window ends, you can use the RestoreAnalysis API operation to remove the DeletionTime stamp and cancel the deletion of the analysis. The analysis remains visible in the API until it's deleted, so you can describe it but you can't make a template from it. An analysis that's scheduled for deletion isn't accessible in the QuickSight console. To access it in the console, restore it. Deleting an analysis doesn't delete the dashboards that you publish from it.

    Args:
        aws_account_id(str): The ID of the Amazon Web Services account; where you want to delete an analysis.
        analysis_id(str): The ID of the analysis that you're deleting.
        recovery_window_in_days(int, optional): A value that specifies the number of days that QuickSight waits before it deletes the analysis. You can't use this parameter with the ForceDeleteWithoutRecovery option in the same API call. The default value is 30. Defaults to None.
        force_delete_without_recovery(bool, optional): This option defaults to the value NoForceDeleteWithoutRecovery. To immediately delete the analysis, add the ForceDeleteWithoutRecovery option. You can't restore an analysis after it's deleted. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.quicksight.analysis.init.delete(
                ctx, aws_account_id=value, analysis_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.quicksight.analysis.init.delete aws_account_id=value, analysis_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="quicksight",
        operation="delete_analysis",
        op_kwargs={
            "AwsAccountId": aws_account_id,
            "AnalysisId": analysis_id,
            "RecoveryWindowInDays": recovery_window_in_days,
            "ForceDeleteWithoutRecovery": force_delete_without_recovery,
        },
    )


async def describe(hub, ctx, aws_account_id: str, analysis_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Provides a summary of the metadata for an analysis.

    Args:
        aws_account_id(str): The ID of the Amazon Web Services account; that contains the analysis. You must be using the Amazon Web Services account; that the analysis is in.
        analysis_id(str): The ID of the analysis that you're describing. The ID is part of the URL of the analysis.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.quicksight.analysis.init.describe(
                ctx, aws_account_id=value, analysis_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.quicksight.analysis.init.describe aws_account_id=value, analysis_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="quicksight",
        operation="describe_analysis",
        op_kwargs={"AwsAccountId": aws_account_id, "AnalysisId": analysis_id},
    )


async def list_all(
    hub, ctx, aws_account_id: str, next_token: str = None, max_results: int = None
) -> Dict:
    r"""
    **Autogenerated function**

    Lists Amazon QuickSight analyses that exist in the specified Amazon Web Services account;.

    Args:
        aws_account_id(str): The ID of the Amazon Web Services account; that contains the analyses.
        next_token(str, optional): A pagination token that can be used in a subsequent request. Defaults to None.
        max_results(int, optional): The maximum number of results to return. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.quicksight.analysis.init.list_all(ctx, aws_account_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.quicksight.analysis.init.list_all aws_account_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="quicksight",
        operation="list_analyses",
        op_kwargs={
            "AwsAccountId": aws_account_id,
            "NextToken": next_token,
            "MaxResults": max_results,
        },
    )


async def restore(hub, ctx, aws_account_id: str, analysis_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Restores an analysis.

    Args:
        aws_account_id(str): The ID of the Amazon Web Services account; that contains the analysis.
        analysis_id(str): The ID of the analysis that you're restoring.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.quicksight.analysis.init.restore(
                ctx, aws_account_id=value, analysis_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.quicksight.analysis.init.restore aws_account_id=value, analysis_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="quicksight",
        operation="restore_analysis",
        op_kwargs={"AwsAccountId": aws_account_id, "AnalysisId": analysis_id},
    )


async def search(
    hub,
    ctx,
    aws_account_id: str,
    filters: List,
    next_token: str = None,
    max_results: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Searches for analyses that belong to the user specified in the filter.  This operation is eventually consistent. The results are best effort and may not reflect very recent updates and changes.

    Args:
        aws_account_id(str): The ID of the Amazon Web Services account; that contains the analyses that you're searching for.
        filters(List): The structure for the search filters that you want to apply to your search. .
        next_token(str, optional): A pagination token that can be used in a subsequent request. Defaults to None.
        max_results(int, optional): The maximum number of results to return. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.quicksight.analysis.init.search(
                ctx, aws_account_id=value, filters=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.quicksight.analysis.init.search aws_account_id=value, filters=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="quicksight",
        operation="search_analyses",
        op_kwargs={
            "AwsAccountId": aws_account_id,
            "Filters": filters,
            "NextToken": next_token,
            "MaxResults": max_results,
        },
    )


async def update(
    hub,
    ctx,
    aws_account_id: str,
    analysis_id: str,
    name: str,
    source_entity: Dict,
    parameters: Dict = None,
    theme_arn: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates an analysis in Amazon QuickSight

    Args:
        aws_account_id(str): The ID of the Amazon Web Services account; that contains the analysis that you're updating.
        analysis_id(str): The ID for the analysis that you're updating. This ID displays in the URL of the analysis.
        name(str): A descriptive name for the analysis that you're updating. This name displays for the analysis in the QuickSight console.
        parameters(Dict, optional): The parameter names and override values that you want to use. An analysis can have any parameter type, and some parameters might accept multiple values. . Defaults to None.
        source_entity(Dict): A source entity to use for the analysis that you're updating. This metadata structure contains details that describe a source template and one or more datasets.
        theme_arn(str, optional): The Amazon Resource Name (ARN) for the theme to apply to the analysis that you're creating. To see the theme in the QuickSight console, make sure that you have access to it. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.quicksight.analysis.init.update(
                ctx, aws_account_id=value, analysis_id=value, name=value, source_entity=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.quicksight.analysis.init.update aws_account_id=value, analysis_id=value, name=value, source_entity=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="quicksight",
        operation="update_analysis",
        op_kwargs={
            "AwsAccountId": aws_account_id,
            "AnalysisId": analysis_id,
            "Name": name,
            "Parameters": parameters,
            "SourceEntity": source_entity,
            "ThemeArn": theme_arn,
        },
    )
