"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def describe_all(hub, ctx, aws_account_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Describes the settings that were used when your QuickSight subscription was first created in this Amazon Web Services account;.

    Args:
        aws_account_id(str): The ID for the Amazon Web Services account; that contains the settings that you want to list.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.quicksight.account.setting.describe_all(
                ctx, aws_account_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.quicksight.account.setting.describe_all aws_account_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="quicksight",
        operation="describe_account_settings",
        op_kwargs={"AwsAccountId": aws_account_id},
    )


async def update_multiple(
    hub,
    ctx,
    aws_account_id: str,
    default_namespace: str,
    notification_email: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates the Amazon QuickSight settings in your Amazon Web Services account;.

    Args:
        aws_account_id(str): The ID for the Amazon Web Services account; that contains the QuickSight settings that you want to list.
        default_namespace(str): The default namespace for this Amazon Web Services account;. Currently, the default is default. Identity and Access Management (IAM) users that register for the first time with QuickSight provide an email that becomes associated with the default namespace.
        notification_email(str, optional): The email address that you want QuickSight to send notifications to regarding your Amazon Web Services account; or QuickSight subscription. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.quicksight.account.setting.update_multiple(
                ctx, aws_account_id=value, default_namespace=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.quicksight.account.setting.update_multiple aws_account_id=value, default_namespace=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="quicksight",
        operation="update_account_settings",
        op_kwargs={
            "AwsAccountId": aws_account_id,
            "DefaultNamespace": default_namespace,
            "NotificationEmail": notification_email,
        },
    )
