"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    aws_account_id: str,
    account_customization: Dict,
    namespace: str = None,
    tags: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates Amazon QuickSight customizations the current Region;. Currently, you can add a custom default theme by using the CreateAccountCustomization or UpdateAccountCustomization API operation. To further customize QuickSight by removing QuickSight sample assets and videos for all new users, see Customizing QuickSight in the Amazon QuickSight User Guide.  You can create customizations for your Amazon Web Services account; or, if you specify a namespace, for a QuickSight namespace instead. Customizations that apply to a namespace always override customizations that apply to an Amazon Web Services account;. To find out which customizations apply, use the DescribeAccountCustomization API operation. Before you use the CreateAccountCustomization API operation to add a theme as the namespace default, make sure that you first share the theme with the namespace. If you don't share it with the namespace, the theme isn't visible to your users even if you make it the default theme. To check if the theme is shared, view the current permissions by using the  DescribeThemePermissions  API operation. To share the theme, grant permissions by using the  UpdateThemePermissions  API operation.

    Args:
        aws_account_id(str): The ID for the Amazon Web Services account; that you want to customize QuickSight for.
        namespace(str, optional): The QuickSight namespace that you want to add customizations to. Defaults to None.
        account_customization(Dict): The QuickSight customizations you're adding in the current Region;. You can add these to an Amazon Web Services account; and a QuickSight namespace.  For example, you can add a default theme by setting AccountCustomization to the midnight theme: "AccountCustomization": { "DefaultTheme": "arn:aws:quicksight::aws:theme/MIDNIGHT" }. Or, you can add a custom theme by specifying "AccountCustomization": { "DefaultTheme": "arn:aws:quicksight:us-west-2:111122223333:theme/bdb844d0-0fe9-4d9d-b520-0fe602d93639" }. .
        tags(List, optional): A list of the tags that you want to attach to this resource. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.quicksight.account.customization.create(
                ctx, aws_account_id=value, account_customization=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.quicksight.account.customization.create aws_account_id=value, account_customization=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="quicksight",
        operation="create_account_customization",
        op_kwargs={
            "AwsAccountId": aws_account_id,
            "Namespace": namespace,
            "AccountCustomization": account_customization,
            "Tags": tags,
        },
    )


async def delete(hub, ctx, aws_account_id: str, namespace: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Deletes all Amazon QuickSight customizations in this Region; for the specified Amazon Web Services account; and QuickSight namespace.

    Args:
        aws_account_id(str): The ID for the Amazon Web Services account; that you want to delete QuickSight customizations from in this Region;.
        namespace(str, optional): The QuickSight namespace that you're deleting the customizations from. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.quicksight.account.customization.delete(
                ctx, aws_account_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.quicksight.account.customization.delete aws_account_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="quicksight",
        operation="delete_account_customization",
        op_kwargs={"AwsAccountId": aws_account_id, "Namespace": namespace},
    )


async def describe(
    hub, ctx, aws_account_id: str, namespace: str = None, resolved: bool = None
) -> Dict:
    r"""
    **Autogenerated function**

    Describes the customizations associated with the provided Amazon Web Services account; and Amazon QuickSight namespace in an Region;. The QuickSight console evaluates which customizations to apply by running this API operation with the Resolved flag included.  To determine what customizations display when you run this command, it can help to visualize the relationship of the entities involved.     Amazon Web Services account; - The Amazon Web Services account; exists at the top of the hierarchy. It has the potential to use all of the Regions; and AWS Services. When you subscribe to QuickSight, you choose one Region; to use as your home Region. That's where your free SPICE capacity is located. You can use QuickSight in any supported Region;.     Region; - In each Region; where you sign in to QuickSight at least once, QuickSight acts as a separate instance of the same service. If you have a user directory, it resides in us-east-1, which is the US East (N. Virginia). Generally speaking, these users have access to QuickSight in any Region;, unless they are constrained to a namespace.  To run the command in a different Region;, you change your Region settings. If you're using the AWS CLI, you can use one of the following options:   Use command line options.    Use named profiles.    Run aws configure to change your default Region;. Use Enter to key the same settings for your keys. For more information, see Configuring the AWS CLI.      Namespace - A QuickSight namespace is a partition that contains users and assets (data sources, datasets, dashboards, and so on). To access assets that are in a specific namespace, users and groups must also be part of the same namespace. People who share a namespace are completely isolated from users and assets in other namespaces, even if they are in the same Amazon Web Services account; and Region;.    Applied customizations - Within an Region;, a set of QuickSight customizations can apply to an Amazon Web Services account; or to a namespace. Settings that you apply to a namespace override settings that you apply to an Amazon Web Services account;. All settings are isolated to a single Region;. To apply them in other Regions;, run the CreateAccountCustomization command in each Region; where you want to apply the same customizations.

    Args:
        aws_account_id(str): The ID for the Amazon Web Services account; that you want to describe QuickSight customizations for.
        namespace(str, optional): The QuickSight namespace that you want to describe QuickSight customizations for. Defaults to None.
        resolved(bool, optional): The Resolved flag works with the other parameters to determine which view of QuickSight customizations is returned. You can add this flag to your command to use the same view that QuickSight uses to identify which customizations to apply to the console. Omit this flag, or set it to no-resolved, to reveal customizations that are configured at different levels. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.quicksight.account.customization.describe(
                ctx, aws_account_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.quicksight.account.customization.describe aws_account_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="quicksight",
        operation="describe_account_customization",
        op_kwargs={
            "AwsAccountId": aws_account_id,
            "Namespace": namespace,
            "Resolved": resolved,
        },
    )


async def update(
    hub, ctx, aws_account_id: str, account_customization: Dict, namespace: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Updates Amazon QuickSight customizations the current Region;. Currently, the only customization you can use is a theme. You can use customizations for your Amazon Web Services account; or, if you specify a namespace, for a QuickSight namespace instead. Customizations that apply to a namespace override customizations that apply to an Amazon Web Services account;. To find out which customizations apply, use the DescribeAccountCustomization API operation.

    Args:
        aws_account_id(str): The ID for the Amazon Web Services account; that you want to update QuickSight customizations for.
        namespace(str, optional): The namespace that you want to update QuickSight customizations for. Defaults to None.
        account_customization(Dict): The QuickSight customizations you're updating in the current Region;. .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.quicksight.account.customization.update(
                ctx, aws_account_id=value, account_customization=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.quicksight.account.customization.update aws_account_id=value, account_customization=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="quicksight",
        operation="update_account_customization",
        op_kwargs={
            "AwsAccountId": aws_account_id,
            "Namespace": namespace,
            "AccountCustomization": account_customization,
        },
    )
