"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def send(
    hub,
    ctx,
    session_token: str = None,
    start_session: Dict = None,
    start_transaction: Dict = None,
    end_session: Dict = None,
    commit_transaction: Dict = None,
    abort_transaction: Dict = None,
    execute_statement: Dict = None,
    fetch_page: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Sends a command to an Amazon QLDB ledger.  Instead of interacting directly with this API, we recommend using the QLDB driver or the QLDB shell to execute data transactions on a ledger.   If you are working with an AWS SDK, use the QLDB driver. The driver provides a high-level abstraction layer above this QLDB Session data plane and manages SendCommand API calls for you. For information and a list of supported programming languages, see Getting started with the driver in the Amazon QLDB Developer Guide.   If you are working with the AWS Command Line Interface (AWS CLI), use the QLDB shell. The shell is a command line interface that uses the QLDB driver to interact with a ledger. For information, see Accessing Amazon QLDB using the QLDB shell.

    Args:
        session_token(str, optional): Specifies the session token for the current command. A session token is constant throughout the life of the session. To obtain a session token, run the StartSession command. This SessionToken is required for every subsequent command that is issued during the current session. Defaults to None.
        start_session(Dict, optional): Command to start a new session. A session token is obtained as part of the response. Defaults to None.
        start_transaction(Dict, optional): Command to start a new transaction. Defaults to None.
        end_session(Dict, optional): Command to end the current session. Defaults to None.
        commit_transaction(Dict, optional): Command to commit the specified transaction. Defaults to None.
        abort_transaction(Dict, optional): Command to abort the current transaction. Defaults to None.
        execute_statement(Dict, optional): Command to execute a statement in the specified transaction. Defaults to None.
        fetch_page(Dict, optional): Command to fetch a page. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.qldb_session_command.send(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.qldb_session_command.send
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="qldb-session",
        operation="send_command",
        op_kwargs={
            "SessionToken": session_token,
            "StartSession": start_session,
            "StartTransaction": start_transaction,
            "EndSession": end_session,
            "CommitTransaction": commit_transaction,
            "AbortTransaction": abort_transaction,
            "ExecuteStatement": execute_statement,
            "FetchPage": fetch_page,
        },
    )
