"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(
    hub,
    ctx,
    name: str,
    block_address: Dict,
    document_id: str,
    digest_tip_address: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Returns a revision data object for a specified document ID and block address. Also returns a proof of the specified revision for verification if DigestTipAddress is provided.

    Args:
        name(str): The name of the ledger.
        block_address(Dict): The block location of the document revision to be verified. An address is an Amazon Ion structure that has two fields: strandId and sequenceNo. For example: {strandId:"BlFTjlSXze9BIh1KOszcE3",sequenceNo:14}.
        document_id(str): The UUID (represented in Base62-encoded text) of the document to be verified.
        digest_tip_address(Dict, optional): The latest block location covered by the digest for which to request a proof. An address is an Amazon Ion structure that has two fields: strandId and sequenceNo. For example: {strandId:"BlFTjlSXze9BIh1KOszcE3",sequenceNo:49}. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.qldb.revision.get(
                ctx, name=value, block_address=value, document_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.qldb.revision.get name=value, block_address=value, document_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="qldb",
        operation="get_revision",
        op_kwargs={
            "Name": name,
            "BlockAddress": block_address,
            "DocumentId": document_id,
            "DigestTipAddress": digest_tip_address,
        },
    )
