"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def update(hub, ctx, name: str, permissions_mode: str) -> Dict:
    r"""
    **Autogenerated function**

    Updates the permissions mode of a ledger.  Before you switch to the STANDARD permissions mode, you must first create all required IAM policies and table tags to avoid disruption to your users. To learn more, see Migrating to the standard permissions mode in the Amazon QLDB Developer Guide.

    Args:
        name(str): The name of the ledger.
        permissions_mode(str): The permissions mode to assign to the ledger. This parameter can have one of the following values:    ALLOW_ALL: A legacy permissions mode that enables access control with API-level granularity for ledgers. This mode allows users who have the SendCommand API permission for this ledger to run all PartiQL commands (hence, ALLOW_ALL) on any tables in the specified ledger. This mode disregards any table-level or command-level IAM permissions policies that you create for the ledger.    STANDARD: (Recommended) A permissions mode that enables access control with finer granularity for ledgers, tables, and PartiQL commands. By default, this mode denies all user requests to run any PartiQL commands on any tables in this ledger. To allow PartiQL commands to run, you must create IAM permissions policies for specific table resources and PartiQL actions, in addition to the SendCommand API permission for the ledger. For information, see Getting started with the standard permissions mode in the Amazon QLDB Developer Guide.    We strongly recommend using the STANDARD permissions mode to maximize the security of your ledger data. .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.qldb.ledger.permission_mode.update(
                ctx, name=value, permissions_mode=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.qldb.ledger.permission_mode.update name=value, permissions_mode=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="qldb",
        operation="update_ledger_permissions_mode",
        op_kwargs={"Name": name, "PermissionsMode": permissions_mode},
    )
