"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(
    hub,
    ctx,
    name: str,
    permissions_mode: str,
    tags: Dict = None,
    deletion_protection: bool = None,
    kms_key: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a new ledger in your account in the current Region.

    Args:
        name(str): The name of the ledger that you want to create. The name must be unique among all of the ledgers in your account in the current Region. Naming constraints for ledger names are defined in Quotas in Amazon QLDB in the Amazon QLDB Developer Guide.
        tags(Dict, optional): The key-value pairs to add as tags to the ledger that you want to create. Tag keys are case sensitive. Tag values are case sensitive and can be null. Defaults to None.
        permissions_mode(str): The permissions mode to assign to the ledger that you want to create. This parameter can have one of the following values:    ALLOW_ALL: A legacy permissions mode that enables access control with API-level granularity for ledgers. This mode allows users who have the SendCommand API permission for this ledger to run all PartiQL commands (hence, ALLOW_ALL) on any tables in the specified ledger. This mode disregards any table-level or command-level IAM permissions policies that you create for the ledger.    STANDARD: (Recommended) A permissions mode that enables access control with finer granularity for ledgers, tables, and PartiQL commands. By default, this mode denies all user requests to run any PartiQL commands on any tables in this ledger. To allow PartiQL commands to run, you must create IAM permissions policies for specific table resources and PartiQL actions, in addition to the SendCommand API permission for the ledger. For information, see Getting started with the standard permissions mode in the Amazon QLDB Developer Guide.    We strongly recommend using the STANDARD permissions mode to maximize the security of your ledger data. .
        deletion_protection(bool, optional): The flag that prevents a ledger from being deleted by any user. If not provided on ledger creation, this feature is enabled (true) by default. If deletion protection is enabled, you must first disable it before you can delete the ledger. You can disable it by calling the UpdateLedger operation to set the flag to false. Defaults to None.
        kms_key(str, optional): The key in Key Management Service (KMS) to use for encryption of data at rest in the ledger. For more information, see Encryption at rest in the Amazon QLDB Developer Guide. Use one of the following options to specify this parameter:    AWS_OWNED_KMS_KEY: Use an KMS key that is owned and managed by Amazon Web Services on your behalf.    Undefined: By default, use an Amazon Web Services owned KMS key.    A valid symmetric customer managed KMS key: Use the specified KMS key in your account that you create, own, and manage. Amazon QLDB does not support asymmetric keys. For more information, see Using symmetric and asymmetric keys in the Key Management Service Developer Guide.   To specify a customer managed KMS key, you can use its key ID, Amazon Resource Name (ARN), alias name, or alias ARN. When using an alias name, prefix it with "alias/". To specify a key in a different account, you must use the key ARN or alias ARN. For example:   Key ID: 1234abcd-12ab-34cd-56ef-1234567890ab    Key ARN: arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab    Alias name: alias/ExampleAlias    Alias ARN: arn:aws:kms:us-east-2:111122223333:alias/ExampleAlias    For more information, see Key identifiers (KeyId) in the Key Management Service Developer Guide. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.qldb.ledger.init.create(ctx, name=value, permissions_mode=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.qldb.ledger.init.create name=value, permissions_mode=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="qldb",
        operation="create_ledger",
        op_kwargs={
            "Name": name,
            "Tags": tags,
            "PermissionsMode": permissions_mode,
            "DeletionProtection": deletion_protection,
            "KmsKey": kms_key,
        },
    )


async def delete(hub, ctx, name: str) -> None:
    r"""
    **Autogenerated function**

    Deletes a ledger and all of its contents. This action is irreversible. If deletion protection is enabled, you must first disable it before you can delete the ledger. You can disable it by calling the UpdateLedger operation to set the flag to false.

    Args:
        name(str): The name of the ledger that you want to delete.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.qldb.ledger.init.delete(ctx, name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.qldb.ledger.init.delete name=value
    """
    return await hub.tool.aws.client.exec(
        ctx, service_name="qldb", operation="delete_ledger", op_kwargs={"Name": name}
    )


async def describe(hub, ctx, name: str) -> Dict:
    r"""
    **Autogenerated function**

    Returns information about a ledger, including its state, permissions mode, encryption at rest settings, and when it was created.

    Args:
        name(str): The name of the ledger that you want to describe.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.qldb.ledger.init.describe(ctx, name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.qldb.ledger.init.describe name=value
    """
    return await hub.tool.aws.client.exec(
        ctx, service_name="qldb", operation="describe_ledger", op_kwargs={"Name": name}
    )


async def list_all(hub, ctx, max_results: int = None, next_token: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Returns an array of ledger summaries that are associated with the current account and Region. This action returns a maximum of 100 items and is paginated so that you can retrieve all the items by calling ListLedgers multiple times.

    Args:
        max_results(int, optional): The maximum number of results to return in a single ListLedgers request. (The actual number of results returned might be fewer.). Defaults to None.
        next_token(str, optional): A pagination token, indicating that you want to retrieve the next page of results. If you received a value for NextToken in the response from a previous ListLedgers call, then you should use that value as input here. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.qldb.ledger.init.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.qldb.ledger.init.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="qldb",
        operation="list_ledgers",
        op_kwargs={"MaxResults": max_results, "NextToken": next_token},
    )


async def update(
    hub, ctx, name: str, deletion_protection: bool = None, kms_key: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Updates properties on a ledger.

    Args:
        name(str): The name of the ledger.
        deletion_protection(bool, optional): The flag that prevents a ledger from being deleted by any user. If not provided on ledger creation, this feature is enabled (true) by default. If deletion protection is enabled, you must first disable it before you can delete the ledger. You can disable it by calling the UpdateLedger operation to set the flag to false. Defaults to None.
        kms_key(str, optional): The key in Key Management Service (KMS) to use for encryption of data at rest in the ledger. For more information, see Encryption at rest in the Amazon QLDB Developer Guide. Use one of the following options to specify this parameter:    AWS_OWNED_KMS_KEY: Use an KMS key that is owned and managed by Amazon Web Services on your behalf.    Undefined: Make no changes to the KMS key of the ledger.    A valid symmetric customer managed KMS key: Use the specified KMS key in your account that you create, own, and manage. Amazon QLDB does not support asymmetric keys. For more information, see Using symmetric and asymmetric keys in the Key Management Service Developer Guide.   To specify a customer managed KMS key, you can use its key ID, Amazon Resource Name (ARN), alias name, or alias ARN. When using an alias name, prefix it with "alias/". To specify a key in a different account, you must use the key ARN or alias ARN. For example:   Key ID: 1234abcd-12ab-34cd-56ef-1234567890ab    Key ARN: arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab    Alias name: alias/ExampleAlias    Alias ARN: arn:aws:kms:us-east-2:111122223333:alias/ExampleAlias    For more information, see Key identifiers (KeyId) in the Key Management Service Developer Guide. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.qldb.ledger.init.update(ctx, name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.qldb.ledger.init.update name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="qldb",
        operation="update_ledger",
        op_kwargs={
            "Name": name,
            "DeletionProtection": deletion_protection,
            "KmsKey": kms_key,
        },
    )
