"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def export(
    hub,
    ctx,
    name: str,
    inclusive_start_time: str,
    exclusive_end_time: str,
    s3_export_configuration: Dict,
    role_arn: str,
) -> Dict:
    r"""
    **Autogenerated function**

    Exports journal contents within a date and time range from a ledger into a specified Amazon Simple Storage Service (Amazon S3) bucket. The data is written as files in Amazon Ion format. If the ledger with the given Name doesn't exist, then throws ResourceNotFoundException. If the ledger with the given Name is in CREATING status, then throws ResourcePreconditionNotMetException. You can initiate up to two concurrent journal export requests for each ledger. Beyond this limit, journal export requests throw LimitExceededException.

    Args:
        name(str): The name of the ledger.
        inclusive_start_time(str): The inclusive start date and time for the range of journal contents to export. The InclusiveStartTime must be in ISO 8601 date and time format and in Universal Coordinated Time (UTC). For example: 2019-06-13T21:36:34Z. The InclusiveStartTime must be before ExclusiveEndTime. If you provide an InclusiveStartTime that is before the ledger's CreationDateTime, Amazon QLDB defaults it to the ledger's CreationDateTime.
        exclusive_end_time(str): The exclusive end date and time for the range of journal contents to export. The ExclusiveEndTime must be in ISO 8601 date and time format and in Universal Coordinated Time (UTC). For example: 2019-06-13T21:36:34Z. The ExclusiveEndTime must be less than or equal to the current UTC date and time.
        s3_export_configuration(Dict): The configuration settings of the Amazon S3 bucket destination for your export request.
        role_arn(str): The Amazon Resource Name (ARN) of the IAM role that grants QLDB permissions for a journal export job to do the following:   Write objects into your Amazon Simple Storage Service (Amazon S3) bucket.   (Optional) Use your customer master key (CMK) in Key Management Service (KMS) for server-side encryption of your exported data.  .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.qldb.journal.to.s3.export(
                ctx,
                name=value,
                inclusive_start_time=value,
                exclusive_end_time=value,
                s3_export_configuration=value,
                role_arn=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.qldb.journal.to.s3.export name=value, inclusive_start_time=value, exclusive_end_time=value, s3_export_configuration=value, role_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="qldb",
        operation="export_journal_to_s3",
        op_kwargs={
            "Name": name,
            "InclusiveStartTime": inclusive_start_time,
            "ExclusiveEndTime": exclusive_end_time,
            "S3ExportConfiguration": s3_export_configuration,
            "RoleArn": role_arn,
        },
    )
