"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def stream(
    hub,
    ctx,
    ledger_name: str,
    role_arn: str,
    inclusive_start_time: str,
    kinesis_configuration: Dict,
    stream_name: str,
    tags: Dict = None,
    exclusive_end_time: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a journal stream for a given Amazon QLDB ledger. The stream captures every document revision that is committed to the ledger's journal and delivers the data to a specified Amazon Kinesis Data Streams resource.

    Args:
        ledger_name(str): The name of the ledger.
        role_arn(str): The Amazon Resource Name (ARN) of the IAM role that grants QLDB permissions for a journal stream to write data records to a Kinesis Data Streams resource.
        tags(Dict, optional): The key-value pairs to add as tags to the stream that you want to create. Tag keys are case sensitive. Tag values are case sensitive and can be null. Defaults to None.
        inclusive_start_time(str): The inclusive start date and time from which to start streaming journal data. This parameter must be in ISO 8601 date and time format and in Universal Coordinated Time (UTC). For example: 2019-06-13T21:36:34Z. The InclusiveStartTime cannot be in the future and must be before ExclusiveEndTime. If you provide an InclusiveStartTime that is before the ledger's CreationDateTime, QLDB effectively defaults it to the ledger's CreationDateTime.
        exclusive_end_time(str, optional): The exclusive date and time that specifies when the stream ends. If you don't define this parameter, the stream runs indefinitely until you cancel it. The ExclusiveEndTime must be in ISO 8601 date and time format and in Universal Coordinated Time (UTC). For example: 2019-06-13T21:36:34Z. Defaults to None.
        kinesis_configuration(Dict): The configuration settings of the Kinesis Data Streams destination for your stream request.
        stream_name(str): The name that you want to assign to the QLDB journal stream. User-defined names can help identify and indicate the purpose of a stream. Your stream name must be unique among other active streams for a given ledger. Stream names have the same naming constraints as ledger names, as defined in Quotas in Amazon QLDB in the Amazon QLDB Developer Guide.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.qldb.journal.to.kinesis.stream(
                ctx,
                ledger_name=value,
                role_arn=value,
                inclusive_start_time=value,
                kinesis_configuration=value,
                stream_name=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.qldb.journal.to.kinesis.stream ledger_name=value, role_arn=value, inclusive_start_time=value, kinesis_configuration=value, stream_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="qldb",
        operation="stream_journal_to_kinesis",
        op_kwargs={
            "LedgerName": ledger_name,
            "RoleArn": role_arn,
            "Tags": tags,
            "InclusiveStartTime": inclusive_start_time,
            "ExclusiveEndTime": exclusive_end_time,
            "KinesisConfiguration": kinesis_configuration,
            "StreamName": stream_name,
        },
    )
