"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def describe(hub, ctx, name: str, export_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Returns information about a journal export job, including the ledger name, export ID, creation time, current status, and the parameters of the original export creation request. This action does not return any expired export jobs. For more information, see Export job expiration in the Amazon QLDB Developer Guide. If the export job with the given ExportId doesn't exist, then throws ResourceNotFoundException. If the ledger with the given Name doesn't exist, then throws ResourceNotFoundException.

    Args:
        name(str): The name of the ledger.
        export_id(str): The UUID (represented in Base62-encoded text) of the journal export job to describe.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.qldb.journal.s3_export.init.describe(
                ctx, name=value, export_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.qldb.journal.s3_export.init.describe name=value, export_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="qldb",
        operation="describe_journal_s3_export",
        op_kwargs={"Name": name, "ExportId": export_id},
    )


async def list_all(hub, ctx, max_results: int = None, next_token: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Returns an array of journal export job descriptions for all ledgers that are associated with the current account and Region. This action returns a maximum of MaxResults items, and is paginated so that you can retrieve all the items by calling ListJournalS3Exports multiple times. This action does not return any expired export jobs. For more information, see Export job expiration in the Amazon QLDB Developer Guide.

    Args:
        max_results(int, optional): The maximum number of results to return in a single ListJournalS3Exports request. (The actual number of results returned might be fewer.). Defaults to None.
        next_token(str, optional): A pagination token, indicating that you want to retrieve the next page of results. If you received a value for NextToken in the response from a previous ListJournalS3Exports call, then you should use that value as input here. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.qldb.journal.s3_export.init.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.qldb.journal.s3_export.init.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="qldb",
        operation="list_journal_s3_exports",
        op_kwargs={"MaxResults": max_results, "NextToken": next_token},
    )
