"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


__func_alias__ = {"list_": "list"}


async def list_(
    hub, ctx, name: str, max_results: int = None, next_token: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Returns an array of journal export job descriptions for a specified ledger. This action returns a maximum of MaxResults items, and is paginated so that you can retrieve all the items by calling ListJournalS3ExportsForLedger multiple times. This action does not return any expired export jobs. For more information, see Export job expiration in the Amazon QLDB Developer Guide.

    Args:
        name(str): The name of the ledger.
        max_results(int, optional): The maximum number of results to return in a single ListJournalS3ExportsForLedger request. (The actual number of results returned might be fewer.). Defaults to None.
        next_token(str, optional): A pagination token, indicating that you want to retrieve the next page of results. If you received a value for NextToken in the response from a previous ListJournalS3ExportsForLedger call, then you should use that value as input here. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.qldb.journal.s3_export.for_ledger.list(ctx, name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.qldb.journal.s3_export.for_ledger.list name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="qldb",
        operation="list_journal_s3_exports_for_ledger",
        op_kwargs={"Name": name, "MaxResults": max_results, "NextToken": next_token},
    )
