"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def cancel(hub, ctx, ledger_name: str, stream_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Ends a given Amazon QLDB journal stream. Before a stream can be canceled, its current status must be ACTIVE. You can't restart a stream after you cancel it. Canceled QLDB stream resources are subject to a 7-day retention period, so they are automatically deleted after this limit expires.

    Args:
        ledger_name(str): The name of the ledger.
        stream_id(str): The UUID (represented in Base62-encoded text) of the QLDB journal stream to be canceled.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.qldb.journal.kinesis_stream.init.cancel(
                ctx, ledger_name=value, stream_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.qldb.journal.kinesis_stream.init.cancel ledger_name=value, stream_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="qldb",
        operation="cancel_journal_kinesis_stream",
        op_kwargs={"LedgerName": ledger_name, "StreamId": stream_id},
    )


async def describe(hub, ctx, ledger_name: str, stream_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Returns detailed information about a given Amazon QLDB journal stream. The output includes the Amazon Resource Name (ARN), stream name, current status, creation time, and the parameters of the original stream creation request. This action does not return any expired journal streams. For more information, see Expiration for terminal streams in the Amazon QLDB Developer Guide.

    Args:
        ledger_name(str): The name of the ledger.
        stream_id(str): The UUID (represented in Base62-encoded text) of the QLDB journal stream to describe.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.qldb.journal.kinesis_stream.init.describe(
                ctx, ledger_name=value, stream_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.qldb.journal.kinesis_stream.init.describe ledger_name=value, stream_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="qldb",
        operation="describe_journal_kinesis_stream",
        op_kwargs={"LedgerName": ledger_name, "StreamId": stream_id},
    )
