"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


__func_alias__ = {"list_": "list"}


async def list_(
    hub, ctx, ledger_name: str, max_results: int = None, next_token: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Returns an array of all Amazon QLDB journal stream descriptors for a given ledger. The output of each stream descriptor includes the same details that are returned by DescribeJournalKinesisStream. This action does not return any expired journal streams. For more information, see Expiration for terminal streams in the Amazon QLDB Developer Guide. This action returns a maximum of MaxResults items. It is paginated so that you can retrieve all the items by calling ListJournalKinesisStreamsForLedger multiple times.

    Args:
        ledger_name(str): The name of the ledger.
        max_results(int, optional): The maximum number of results to return in a single ListJournalKinesisStreamsForLedger request. (The actual number of results returned might be fewer.). Defaults to None.
        next_token(str, optional): A pagination token, indicating that you want to retrieve the next page of results. If you received a value for NextToken in the response from a previous ListJournalKinesisStreamsForLedger call, you should use that value as input here. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.qldb.journal.kinesis_stream.for_ledger.list(
                ctx, ledger_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.qldb.journal.kinesis_stream.for_ledger.list ledger_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="qldb",
        operation="list_journal_kinesis_streams_for_ledger",
        op_kwargs={
            "LedgerName": ledger_name,
            "MaxResults": max_results,
            "NextToken": next_token,
        },
    )
