"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(hub, ctx, name: str) -> Dict:
    r"""
    **Autogenerated function**

    Returns the digest of a ledger at the latest committed block in the journal. The response includes a 256-bit hash value and a block address.

    Args:
        name(str): The name of the ledger.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.qldb.digest.get(ctx, name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.qldb.digest.get name=value
    """
    return await hub.tool.aws.client.exec(
        ctx, service_name="qldb", operation="get_digest", op_kwargs={"Name": name}
    )
